package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxyConsumer;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxySupplier;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxy;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.undertow.configuration.FileConsumer;
import org.wildfly.swarm.config.undertow.configuration.FileSupplier;
import org.wildfly.swarm.config.undertow.configuration.File;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Undertow handlers
 */
@Address("/subsystem=undertow/configuration=handler")
@ResourceType("configuration")
@Implicit
public class HandlerConfiguration<T extends HandlerConfiguration<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private HandlerConfigurationResources subresources = new HandlerConfigurationResources();

	public HandlerConfiguration() {
		super();
		this.key = "handler";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public HandlerConfigurationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ReverseProxy objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ReverseProxy objects.
	 */
	@SuppressWarnings("unchecked")
	public T reverseProxies(java.util.List<ReverseProxy> value) {
		this.subresources.reverseProxies = value;
		return (T) this;
	}

	/**
	 * Add the ReverseProxy object to the list of subresources
	 * 
	 * @param value
	 *            The ReverseProxy to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T reverseProxy(ReverseProxy value) {
		this.subresources.reverseProxies.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ReverseProxy object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ReverseProxy resource
	 * @param config
	 *            The ReverseProxyConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T reverseProxy(java.lang.String childKey,
			ReverseProxyConsumer consumer) {
		ReverseProxy<? extends ReverseProxy> child = new ReverseProxy<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		reverseProxy(child);
		return (T) this;
	}

	/**
	 * Create and configure a ReverseProxy object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ReverseProxy resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T reverseProxy(java.lang.String childKey) {
		reverseProxy(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ReverseProxy object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T reverseProxy(ReverseProxySupplier supplier) {
		reverseProxy(supplier.get());
		return (T) this;
	}

	/**
	 * Add all File objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of File objects.
	 */
	@SuppressWarnings("unchecked")
	public T files(java.util.List<File> value) {
		this.subresources.files = value;
		return (T) this;
	}

	/**
	 * Add the File object to the list of subresources
	 * 
	 * @param value
	 *            The File to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T file(File value) {
		this.subresources.files.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a File object to the list of subresources
	 * 
	 * @param key
	 *            The key for the File resource
	 * @param config
	 *            The FileConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T file(java.lang.String childKey, FileConsumer consumer) {
		File<? extends File> child = new File<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		file(child);
		return (T) this;
	}

	/**
	 * Create and configure a File object to the list of subresources
	 * 
	 * @param key
	 *            The key for the File resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T file(java.lang.String childKey) {
		file(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied File object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T file(FileSupplier supplier) {
		file(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for HandlerConfiguration
	 */
	public static class HandlerConfigurationResources {
		/**
		 * A reverse proxy handler
		 */
		@ResourceDocumentation("A reverse proxy handler")
		@SubresourceInfo("reverseProxy")
		private List<ReverseProxy> reverseProxies = new java.util.ArrayList<>();
		/**
		 * File handler
		 */
		@ResourceDocumentation("File handler")
		@SubresourceInfo("file")
		private List<File> files = new java.util.ArrayList<>();

		/**
		 * Get the list of ReverseProxy resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ReverseProxy> reverseProxies() {
			return this.reverseProxies;
		}

		public ReverseProxy reverseProxy(java.lang.String key) {
			return this.reverseProxies.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of File resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<File> files() {
			return this.files;
		}

		public File file(java.lang.String key) {
			return this.files.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}
}