package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.undertow.HandlerConfiguration;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface HandlerConfigurationConsumer<T extends HandlerConfiguration<T>> {

	/**
	 * Configure a pre-constructed instance of HandlerConfiguration resource
	 * 
	 * @parameter Instance of HandlerConfiguration to configure
	 * @return nothing
	 */
	void accept(T value);

	default HandlerConfigurationConsumer<T> andThen(
			HandlerConfigurationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}