package org.wildfly.swarm.config.undertow.configuration.mod_cluster;

import org.wildfly.swarm.config.undertow.configuration.mod_cluster.NoneAffinity;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface NoneAffinityConsumer<T extends NoneAffinity<T>> {

	/**
	 * Configure a pre-constructed instance of NoneAffinity resource
	 * 
	 * @parameter Instance of NoneAffinity to configure
	 * @return nothing
	 */
	void accept(T value);

	default NoneAffinityConsumer<T> andThen(NoneAffinityConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}