package org.wildfly.swarm.config.undertow.configuration.mod_cluster;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Web requests will have an affinity for the first available node in a list
 * typically comprised of: primary owner, backup nodes, local node (if not a
 * primary nor backup owner).
 */
@Address("/subsystem=undertow/configuration=filter/mod-cluster=*/affinity=ranked")
@ResourceType("affinity")
@Implicit
public class RankedAffinity<T extends RankedAffinity<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The delimiter used to separate ranked routes within the session ID.")
	private String delimiter;

	public RankedAffinity() {
		super();
		this.key = "ranked";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The delimiter used to separate ranked routes within the session ID.
	 */
	@ModelNodeBinding(detypedName = "delimiter")
	public String delimiter() {
		return this.delimiter;
	}

	/**
	 * The delimiter used to separate ranked routes within the session ID.
	 */
	@SuppressWarnings("unchecked")
	public T delimiter(java.lang.String value) {
		Object oldValue = this.delimiter;
		this.delimiter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("delimiter", oldValue, value);
		return (T) this;
	}
}