package org.wildfly.swarm.config.undertow.configuration.mod_cluster;

import org.wildfly.swarm.config.undertow.configuration.mod_cluster.RankedAffinity;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RankedAffinityConsumer<T extends RankedAffinity<T>> {

	/**
	 * Configure a pre-constructed instance of RankedAffinity resource
	 * 
	 * @parameter Instance of RankedAffinity to configure
	 * @return nothing
	 */
	void accept(T value);

	default RankedAffinityConsumer<T> andThen(RankedAffinityConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}