package org.wildfly.swarm.config.undertow.configuration.mod_cluster;

import org.wildfly.swarm.config.undertow.configuration.mod_cluster.SingleAffinity;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SingleAffinityConsumer<T extends SingleAffinity<T>> {

	/**
	 * Configure a pre-constructed instance of SingleAffinity resource
	 * 
	 * @parameter Instance of SingleAffinity to configure
	 * @return nothing
	 */
	void accept(T value);

	default SingleAffinityConsumer<T> andThen(SingleAffinityConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}