package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Allows the access log to be written to the console.
 */
@Address("/subsystem=undertow/server=*/host=*/setting=console-access-log")
@ResourceType("setting")
@Implicit
public class ConsoleAccessLogSetting<T extends ConsoleAccessLogSetting<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The attributes to be included in the structured output.")
	private Map attributes;
	@AttributeDocumentation("Indicates whether or not the host name should included in the JSON structured output. If set to true the key will be hostName in the structured data and the value will be the host this console-access-log belongs to.")
	private Boolean includeHostName;
	@AttributeDocumentation("Any additional metadata to add to the JSON structured output.")
	private Map metadata;
	@AttributeDocumentation("Predicate that determines if the request should be logged.")
	private String predicate;
	@AttributeDocumentation("Name of the worker to use for logging.")
	private String worker;

	public ConsoleAccessLogSetting() {
		super();
		this.key = "console-access-log";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The attributes to be included in the structured output.
	 */
	@ModelNodeBinding(detypedName = "attributes")
	public Map attributes() {
		return this.attributes;
	}

	/**
	 * The attributes to be included in the structured output.
	 */
	@SuppressWarnings("unchecked")
	public T attributes(java.util.Map value) {
		Object oldValue = this.attributes;
		this.attributes = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributes", oldValue, value);
		return (T) this;
	}

	/**
	 * The attributes to be included in the structured output.
	 */
	@SuppressWarnings("unchecked")
	public T attribute(java.lang.String key, java.lang.Object value) {
		if (this.attributes == null) {
			this.attributes = new java.util.HashMap<>();
		}
		this.attributes.put(key, value);
		return (T) this;
	}

	/**
	 * Indicates whether or not the host name should included in the JSON
	 * structured output. If set to true the key will be hostName in the
	 * structured data and the value will be the host this console-access-log
	 * belongs to.
	 */
	@ModelNodeBinding(detypedName = "include-host-name")
	public Boolean includeHostName() {
		return this.includeHostName;
	}

	/**
	 * Indicates whether or not the host name should included in the JSON
	 * structured output. If set to true the key will be hostName in the
	 * structured data and the value will be the host this console-access-log
	 * belongs to.
	 */
	@SuppressWarnings("unchecked")
	public T includeHostName(java.lang.Boolean value) {
		Object oldValue = this.includeHostName;
		this.includeHostName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("includeHostName", oldValue, value);
		return (T) this;
	}

	/**
	 * Any additional metadata to add to the JSON structured output.
	 */
	@ModelNodeBinding(detypedName = "metadata")
	public Map metadata() {
		return this.metadata;
	}

	/**
	 * Any additional metadata to add to the JSON structured output.
	 */
	@SuppressWarnings("unchecked")
	public T metadata(java.util.Map value) {
		Object oldValue = this.metadata;
		this.metadata = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("metadata", oldValue, value);
		return (T) this;
	}

	/**
	 * Any additional metadata to add to the JSON structured output.
	 */
	@SuppressWarnings("unchecked")
	public T metadatum(java.lang.String key, java.lang.Object value) {
		if (this.metadata == null) {
			this.metadata = new java.util.HashMap<>();
		}
		this.metadata.put(key, value);
		return (T) this;
	}

	/**
	 * Predicate that determines if the request should be logged.
	 */
	@ModelNodeBinding(detypedName = "predicate")
	public String predicate() {
		return this.predicate;
	}

	/**
	 * Predicate that determines if the request should be logged.
	 */
	@SuppressWarnings("unchecked")
	public T predicate(java.lang.String value) {
		Object oldValue = this.predicate;
		this.predicate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("predicate", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the worker to use for logging.
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * Name of the worker to use for logging.
	 */
	@SuppressWarnings("unchecked")
	public T worker(java.lang.String value) {
		Object oldValue = this.worker;
		this.worker = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("worker", oldValue, value);
		return (T) this;
	}
}