package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.undertow.server.host.ConsoleAccessLogSetting;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConsoleAccessLogSettingConsumer<T extends ConsoleAccessLogSetting<T>> {

	/**
	 * Configure a pre-constructed instance of ConsoleAccessLogSetting resource
	 * 
	 * @parameter Instance of ConsoleAccessLogSetting to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConsoleAccessLogSettingConsumer<T> andThen(
			ConsoleAccessLogSettingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}