package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Reference to filter
 */
@Addresses({"/subsystem=undertow/server=*/host=*/filter-ref=*",
		"/subsystem=undertow/server=*/host=*/location=*/filter-ref=*"})
@ResourceType("filter-ref")
public class FilterRef<T extends FilterRef<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Predicates provide a simple way of making a true/false decision  based on an exchange. Many handlers have a requirement that they be applied conditionally, and predicates provide a general way to specify a condition.")
	private String predicate;
	@AttributeDocumentation("Defines filter order. A lower number instructs the server to be included earlier in the handler chain than others with higher numbers. Values range from 1, indicating the filter will be handled first, to 2147483647, resulting in the filter being handled last.")
	private Integer priority;

	public FilterRef(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Predicates provide a simple way of making a true/false decision based on
	 * an exchange. Many handlers have a requirement that they be applied
	 * conditionally, and predicates provide a general way to specify a
	 * condition.
	 */
	@ModelNodeBinding(detypedName = "predicate")
	public String predicate() {
		return this.predicate;
	}

	/**
	 * Predicates provide a simple way of making a true/false decision based on
	 * an exchange. Many handlers have a requirement that they be applied
	 * conditionally, and predicates provide a general way to specify a
	 * condition.
	 */
	@SuppressWarnings("unchecked")
	public T predicate(java.lang.String value) {
		Object oldValue = this.predicate;
		this.predicate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("predicate", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines filter order. A lower number instructs the server to be included
	 * earlier in the handler chain than others with higher numbers. Values
	 * range from 1, indicating the filter will be handled first, to 2147483647,
	 * resulting in the filter being handled last.
	 */
	@ModelNodeBinding(detypedName = "priority")
	public Integer priority() {
		return this.priority;
	}

	/**
	 * Defines filter order. A lower number instructs the server to be included
	 * earlier in the handler chain than others with higher numbers. Values
	 * range from 1, indicating the filter will be handled first, to 2147483647,
	 * resulting in the filter being handled last.
	 */
	@SuppressWarnings("unchecked")
	public T priority(java.lang.Integer value) {
		Object oldValue = this.priority;
		this.priority = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("priority", oldValue, value);
		return (T) this;
	}
}