package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * If websockets are enabled for this container
 */
@Address("/subsystem=undertow/servlet-container=*/setting=websockets")
@ResourceType("setting")
@Implicit
public class WebsocketsSetting<T extends WebsocketsSetting<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The buffer pool to use for websocket deployments")
	private String bufferPool;
	@AttributeDocumentation("Configures the level of compression of the DEFLATE algorithm")
	private Integer deflaterLevel;
	@AttributeDocumentation("If callbacks should be dispatched to a worker thread. If this is false then they will be run in the IO thread, which is faster however care must be taken not to perform blocking operations.")
	private Boolean dispatchToWorker;
	@AttributeDocumentation("Enables websocket's per-message compression extension, RFC-7692")
	private Boolean perMessageDeflate;
	@AttributeDocumentation("The worker to use for websocket deployments")
	private String worker;

	public WebsocketsSetting() {
		super();
		this.key = "websockets";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The buffer pool to use for websocket deployments
	 */
	@ModelNodeBinding(detypedName = "buffer-pool")
	public String bufferPool() {
		return this.bufferPool;
	}

	/**
	 * The buffer pool to use for websocket deployments
	 */
	@SuppressWarnings("unchecked")
	public T bufferPool(java.lang.String value) {
		Object oldValue = this.bufferPool;
		this.bufferPool = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bufferPool", oldValue, value);
		return (T) this;
	}

	/**
	 * Configures the level of compression of the DEFLATE algorithm
	 */
	@ModelNodeBinding(detypedName = "deflater-level")
	public Integer deflaterLevel() {
		return this.deflaterLevel;
	}

	/**
	 * Configures the level of compression of the DEFLATE algorithm
	 */
	@SuppressWarnings("unchecked")
	public T deflaterLevel(java.lang.Integer value) {
		Object oldValue = this.deflaterLevel;
		this.deflaterLevel = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deflaterLevel", oldValue, value);
		return (T) this;
	}

	/**
	 * If callbacks should be dispatched to a worker thread. If this is false
	 * then they will be run in the IO thread, which is faster however care must
	 * be taken not to perform blocking operations.
	 */
	@ModelNodeBinding(detypedName = "dispatch-to-worker")
	public Boolean dispatchToWorker() {
		return this.dispatchToWorker;
	}

	/**
	 * If callbacks should be dispatched to a worker thread. If this is false
	 * then they will be run in the IO thread, which is faster however care must
	 * be taken not to perform blocking operations.
	 */
	@SuppressWarnings("unchecked")
	public T dispatchToWorker(java.lang.Boolean value) {
		Object oldValue = this.dispatchToWorker;
		this.dispatchToWorker = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dispatchToWorker", oldValue, value);
		return (T) this;
	}

	/**
	 * Enables websocket's per-message compression extension, RFC-7692
	 */
	@ModelNodeBinding(detypedName = "per-message-deflate")
	public Boolean perMessageDeflate() {
		return this.perMessageDeflate;
	}

	/**
	 * Enables websocket's per-message compression extension, RFC-7692
	 */
	@SuppressWarnings("unchecked")
	public T perMessageDeflate(java.lang.Boolean value) {
		Object oldValue = this.perMessageDeflate;
		this.perMessageDeflate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("perMessageDeflate", oldValue, value);
		return (T) this;
	}

	/**
	 * The worker to use for websocket deployments
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * The worker to use for websocket deployments
	 */
	@SuppressWarnings("unchecked")
	public T worker(java.lang.String value) {
		Object oldValue = this.worker;
		this.worker = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("worker", oldValue, value);
		return (T) this;
	}
}