/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.deployment.scanner.Scanner;
import org.wildfly.swarm.config.deployment.scanner.ScannerConsumer;
import org.wildfly.swarm.config.deployment.scanner.ScannerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=deployment-scanner")
@ResourceType(value="subsystem")
@Implicit
public class DeploymentScanner<T extends DeploymentScanner<T>>
implements Keyed {
    private String key = "deployment-scanner";
    private PropertyChangeSupport pcs;
    private DeploymentScannerResources subresources = new DeploymentScannerResources();

    public DeploymentScanner() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public DeploymentScannerResources subresources() {
        return this.subresources;
    }

    public T scanners(List<Scanner> value) {
        this.subresources.scanners = value;
        return (T)this;
    }

    public T scanner(Scanner value) {
        this.subresources.scanners.add(value);
        return (T)this;
    }

    public T scanner(String childKey, ScannerConsumer consumer) {
        Scanner child = new Scanner(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.scanner(child);
        return (T)this;
    }

    public T scanner(String childKey) {
        this.scanner(childKey, null);
        return (T)this;
    }

    public T scanner(ScannerSupplier supplier) {
        this.scanner(supplier.get());
        return (T)this;
    }

    public static class DeploymentScannerResources {
        @ResourceDocumentation(value="The configuration of the deployment scanner subsystem")
        @SubresourceInfo(value="scanner")
        private List<Scanner> scanners = new ArrayList<Scanner>();

        @Subresource
        public List<Scanner> scanners() {
            return this.scanners;
        }

        public Scanner scanner(String key) {
            return this.scanners.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

