/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.discovery.AggregateProvider;
import org.wildfly.swarm.config.discovery.AggregateProviderConsumer;
import org.wildfly.swarm.config.discovery.AggregateProviderSupplier;
import org.wildfly.swarm.config.discovery.StaticProvider;
import org.wildfly.swarm.config.discovery.StaticProviderConsumer;
import org.wildfly.swarm.config.discovery.StaticProviderSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=discovery")
@ResourceType(value="subsystem")
@Implicit
public class Discovery<T extends Discovery<T>>
implements Keyed {
    private String key = "discovery";
    private PropertyChangeSupport pcs;
    private DiscoveryResources subresources = new DiscoveryResources();

    public Discovery() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public DiscoveryResources subresources() {
        return this.subresources;
    }

    public T staticProviders(List<StaticProvider> value) {
        this.subresources.staticProviders = value;
        return (T)this;
    }

    public T staticProvider(StaticProvider value) {
        this.subresources.staticProviders.add(value);
        return (T)this;
    }

    public T staticProvider(String childKey, StaticProviderConsumer consumer) {
        StaticProvider child = new StaticProvider(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.staticProvider(child);
        return (T)this;
    }

    public T staticProvider(String childKey) {
        this.staticProvider(childKey, null);
        return (T)this;
    }

    public T staticProvider(StaticProviderSupplier supplier) {
        this.staticProvider(supplier.get());
        return (T)this;
    }

    public T aggregateProviders(List<AggregateProvider> value) {
        this.subresources.aggregateProviders = value;
        return (T)this;
    }

    public T aggregateProvider(AggregateProvider value) {
        this.subresources.aggregateProviders.add(value);
        return (T)this;
    }

    public T aggregateProvider(String childKey, AggregateProviderConsumer consumer) {
        AggregateProvider child = new AggregateProvider(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.aggregateProvider(child);
        return (T)this;
    }

    public T aggregateProvider(String childKey) {
        this.aggregateProvider(childKey, null);
        return (T)this;
    }

    public T aggregateProvider(AggregateProviderSupplier supplier) {
        this.aggregateProvider(supplier.get());
        return (T)this;
    }

    public static class DiscoveryResources {
        @ResourceDocumentation(value="A static discovery provider definition")
        @SubresourceInfo(value="staticProvider")
        private List<StaticProvider> staticProviders = new ArrayList<StaticProvider>();
        @ResourceDocumentation(value="An aggregate discovery provider definition")
        @SubresourceInfo(value="aggregateProvider")
        private List<AggregateProvider> aggregateProviders = new ArrayList<AggregateProvider>();

        @Subresource
        public List<StaticProvider> staticProviders() {
            return this.staticProviders;
        }

        public StaticProvider staticProvider(String key) {
            return this.staticProviders.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<AggregateProvider> aggregateProviders() {
            return this.aggregateProviders;
        }

        public AggregateProvider aggregateProvider(String key) {
            return this.aggregateProviders.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

