/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.ejb3.ApplicationSecurityDomain;
import org.wildfly.swarm.config.ejb3.ApplicationSecurityDomainConsumer;
import org.wildfly.swarm.config.ejb3.ApplicationSecurityDomainSupplier;
import org.wildfly.swarm.config.ejb3.AsyncService;
import org.wildfly.swarm.config.ejb3.AsyncServiceConsumer;
import org.wildfly.swarm.config.ejb3.AsyncServiceSupplier;
import org.wildfly.swarm.config.ejb3.Cache;
import org.wildfly.swarm.config.ejb3.CacheConsumer;
import org.wildfly.swarm.config.ejb3.CacheSupplier;
import org.wildfly.swarm.config.ejb3.ClusterPassivationStore;
import org.wildfly.swarm.config.ejb3.ClusterPassivationStoreConsumer;
import org.wildfly.swarm.config.ejb3.ClusterPassivationStoreSupplier;
import org.wildfly.swarm.config.ejb3.FilePassivationStore;
import org.wildfly.swarm.config.ejb3.FilePassivationStoreConsumer;
import org.wildfly.swarm.config.ejb3.FilePassivationStoreSupplier;
import org.wildfly.swarm.config.ejb3.IIOPService;
import org.wildfly.swarm.config.ejb3.IIOPServiceConsumer;
import org.wildfly.swarm.config.ejb3.IIOPServiceSupplier;
import org.wildfly.swarm.config.ejb3.IdentityService;
import org.wildfly.swarm.config.ejb3.IdentityServiceConsumer;
import org.wildfly.swarm.config.ejb3.IdentityServiceSupplier;
import org.wildfly.swarm.config.ejb3.MDBDeliveryGroup;
import org.wildfly.swarm.config.ejb3.MDBDeliveryGroupConsumer;
import org.wildfly.swarm.config.ejb3.MDBDeliveryGroupSupplier;
import org.wildfly.swarm.config.ejb3.PassivationStore;
import org.wildfly.swarm.config.ejb3.PassivationStoreConsumer;
import org.wildfly.swarm.config.ejb3.PassivationStoreSupplier;
import org.wildfly.swarm.config.ejb3.RemoteService;
import org.wildfly.swarm.config.ejb3.RemoteServiceConsumer;
import org.wildfly.swarm.config.ejb3.RemoteServiceSupplier;
import org.wildfly.swarm.config.ejb3.RemotingProfile;
import org.wildfly.swarm.config.ejb3.RemotingProfileConsumer;
import org.wildfly.swarm.config.ejb3.RemotingProfileSupplier;
import org.wildfly.swarm.config.ejb3.StrictMaxBeanInstancePool;
import org.wildfly.swarm.config.ejb3.StrictMaxBeanInstancePoolConsumer;
import org.wildfly.swarm.config.ejb3.StrictMaxBeanInstancePoolSupplier;
import org.wildfly.swarm.config.ejb3.ThreadPool;
import org.wildfly.swarm.config.ejb3.ThreadPoolConsumer;
import org.wildfly.swarm.config.ejb3.ThreadPoolSupplier;
import org.wildfly.swarm.config.ejb3.TimerService;
import org.wildfly.swarm.config.ejb3.TimerServiceConsumer;
import org.wildfly.swarm.config.ejb3.TimerServiceSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=ejb3")
@ResourceType(value="subsystem")
@Implicit
public class EJB3<T extends EJB3<T>>
implements Keyed {
    private String key = "ejb3";
    private PropertyChangeSupport pcs;
    private EJB3Resources subresources = new EJB3Resources();
    @AttributeDocumentation(value="If this is true then regular expressions can be used in interceptor bindings to allow interceptors to be mapped to all beans that match the regular expression")
    private Boolean allowEjbNameRegex;
    @AttributeDocumentation(value="Client interceptor definitions.")
    private List<Map> clientInterceptors;
    @AttributeDocumentation(value="Name of the default stateful bean cache, which will be applicable to all clustered stateful EJBs, unless overridden at the deployment or bean level")
    private String defaultClusteredSfsbCache;
    @AttributeDocumentation(value="The default distinct name that is applied to every EJB deployed on this server")
    private String defaultDistinctName;
    @AttributeDocumentation(value="Name of the default entity bean instance pool, which will be applicable to all entity beans, unless overridden at the deployment or bean level")
    private String defaultEntityBeanInstancePool;
    @AttributeDocumentation(value="If set to true entity beans will use optimistic locking by default")
    private Boolean defaultEntityBeanOptimisticLocking;
    @AttributeDocumentation(value="Name of the default MDB instance pool, which will be applicable to all MDBs, unless overridden at the deployment or bean level")
    private String defaultMdbInstancePool;
    @AttributeDocumentation(value="If this is set to true then methods on an EJB with a security domain specified or with other methods with security metadata will have an implicit @DenyAll unless other security metadata is present")
    private Boolean defaultMissingMethodPermissionsDenyAccess;
    @AttributeDocumentation(value="Name of the default resource adapter name that will be used by MDBs, unless overridden at the deployment or bean level")
    private String defaultResourceAdapterName;
    @AttributeDocumentation(value="The default security domain that will be used for EJBs if the bean doesn't explicitly specify one")
    private String defaultSecurityDomain;
    @AttributeDocumentation(value="Name of the default stateful bean cache, which will be applicable to all stateful EJBs, unless overridden at the deployment or bean level")
    private String defaultSfsbCache;
    @AttributeDocumentation(value="Name of the default stateful bean cache, which will be applicable to all stateful EJBs which have passivation disabled. Each deployment or EJB can optionally override this cache name.")
    private String defaultSfsbPassivationDisabledCache;
    @AttributeDocumentation(value="The default access timeout for singleton beans")
    private Long defaultSingletonBeanAccessTimeout;
    @AttributeDocumentation(value="Name of the default stateless bean instance pool, which will be applicable to all stateless EJBs, unless overridden at the deployment or bean level")
    private String defaultSlsbInstancePool;
    @AttributeDocumentation(value="The default access timeout for stateful beans")
    private Long defaultStatefulBeanAccessTimeout;
    @AttributeDocumentation(value="This deprecated attribute has no effect and will be removed in a future release; it may never be set to a \"false\" value")
    private Boolean disableDefaultEjbPermissions;
    @AttributeDocumentation(value="Enabling txn graceful shutdown will make the server wait for active EJB-related transactions to complete before suspending. For that reason, if the server is running on a cluster, the suspending cluster node may receive ejb requests until all active transactions are complete. To avoid this behavior, omit this tag.")
    private Boolean enableGracefulTxnShutdown;
    @AttributeDocumentation(value="If set to true, enable the collection of invocation statistics. Deprecated in favour of \"statistics-enabled\"")
    private Boolean enableStatistics;
    @AttributeDocumentation(value="If set to false, the parameters to invocations on remote interface of an EJB, will be passed by reference. Else, the parameters will be passed by value.")
    private Boolean inVmRemoteInterfaceInvocationPassByValue;
    @AttributeDocumentation(value="If this is true then all EJB system (not application) exceptions will be logged. The EJB spec mandates this behaviour, however it is not recommended as it will often result in exceptions being logged twice (once by the EJB and once by the calling code)")
    private Boolean logSystemExceptions;
    @AttributeDocumentation(value="Server interceptor definitions.")
    private List<Map> serverInterceptors;
    @AttributeDocumentation(value="If set to true, enable the collection of invocation statistics.")
    private Boolean statisticsEnabled;

    public EJB3() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public EJB3Resources subresources() {
        return this.subresources;
    }

    public T applicationSecurityDomains(List<ApplicationSecurityDomain> value) {
        this.subresources.applicationSecurityDomains = value;
        return (T)this;
    }

    public T applicationSecurityDomain(ApplicationSecurityDomain value) {
        this.subresources.applicationSecurityDomains.add(value);
        return (T)this;
    }

    public T applicationSecurityDomain(String childKey, ApplicationSecurityDomainConsumer consumer) {
        ApplicationSecurityDomain child = new ApplicationSecurityDomain(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.applicationSecurityDomain(child);
        return (T)this;
    }

    public T applicationSecurityDomain(String childKey) {
        this.applicationSecurityDomain(childKey, null);
        return (T)this;
    }

    public T applicationSecurityDomain(ApplicationSecurityDomainSupplier supplier) {
        this.applicationSecurityDomain(supplier.get());
        return (T)this;
    }

    public T strictMaxBeanInstancePools(List<StrictMaxBeanInstancePool> value) {
        this.subresources.strictMaxBeanInstancePools = value;
        return (T)this;
    }

    public T strictMaxBeanInstancePool(StrictMaxBeanInstancePool value) {
        this.subresources.strictMaxBeanInstancePools.add(value);
        return (T)this;
    }

    public T strictMaxBeanInstancePool(String childKey, StrictMaxBeanInstancePoolConsumer consumer) {
        StrictMaxBeanInstancePool child = new StrictMaxBeanInstancePool(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.strictMaxBeanInstancePool(child);
        return (T)this;
    }

    public T strictMaxBeanInstancePool(String childKey) {
        this.strictMaxBeanInstancePool(childKey, null);
        return (T)this;
    }

    public T strictMaxBeanInstancePool(StrictMaxBeanInstancePoolSupplier supplier) {
        this.strictMaxBeanInstancePool(supplier.get());
        return (T)this;
    }

    public T caches(List<Cache> value) {
        this.subresources.caches = value;
        return (T)this;
    }

    public T cache(Cache value) {
        this.subresources.caches.add(value);
        return (T)this;
    }

    public T cache(String childKey, CacheConsumer consumer) {
        Cache child = new Cache(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.cache(child);
        return (T)this;
    }

    public T cache(String childKey) {
        this.cache(childKey, null);
        return (T)this;
    }

    public T cache(CacheSupplier supplier) {
        this.cache(supplier.get());
        return (T)this;
    }

    public T remotingProfiles(List<RemotingProfile> value) {
        this.subresources.remotingProfiles = value;
        return (T)this;
    }

    public T remotingProfile(RemotingProfile value) {
        this.subresources.remotingProfiles.add(value);
        return (T)this;
    }

    public T remotingProfile(String childKey, RemotingProfileConsumer consumer) {
        RemotingProfile child = new RemotingProfile(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.remotingProfile(child);
        return (T)this;
    }

    public T remotingProfile(String childKey) {
        this.remotingProfile(childKey, null);
        return (T)this;
    }

    public T remotingProfile(RemotingProfileSupplier supplier) {
        this.remotingProfile(supplier.get());
        return (T)this;
    }

    public T clusterPassivationStores(List<ClusterPassivationStore> value) {
        this.subresources.clusterPassivationStores = value;
        return (T)this;
    }

    public T clusterPassivationStore(ClusterPassivationStore value) {
        this.subresources.clusterPassivationStores.add(value);
        return (T)this;
    }

    public T clusterPassivationStore(String childKey, ClusterPassivationStoreConsumer consumer) {
        ClusterPassivationStore child = new ClusterPassivationStore(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.clusterPassivationStore(child);
        return (T)this;
    }

    public T clusterPassivationStore(String childKey) {
        this.clusterPassivationStore(childKey, null);
        return (T)this;
    }

    public T clusterPassivationStore(ClusterPassivationStoreSupplier supplier) {
        this.clusterPassivationStore(supplier.get());
        return (T)this;
    }

    public T passivationStores(List<PassivationStore> value) {
        this.subresources.passivationStores = value;
        return (T)this;
    }

    public T passivationStore(PassivationStore value) {
        this.subresources.passivationStores.add(value);
        return (T)this;
    }

    public T passivationStore(String childKey, PassivationStoreConsumer consumer) {
        PassivationStore child = new PassivationStore(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.passivationStore(child);
        return (T)this;
    }

    public T passivationStore(String childKey) {
        this.passivationStore(childKey, null);
        return (T)this;
    }

    public T passivationStore(PassivationStoreSupplier supplier) {
        this.passivationStore(supplier.get());
        return (T)this;
    }

    public T mdbDeliveryGroups(List<MDBDeliveryGroup> value) {
        this.subresources.mdbDeliveryGroups = value;
        return (T)this;
    }

    public T mdbDeliveryGroup(MDBDeliveryGroup value) {
        this.subresources.mdbDeliveryGroups.add(value);
        return (T)this;
    }

    public T mdbDeliveryGroup(String childKey, MDBDeliveryGroupConsumer consumer) {
        MDBDeliveryGroup child = new MDBDeliveryGroup(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.mdbDeliveryGroup(child);
        return (T)this;
    }

    public T mdbDeliveryGroup(String childKey) {
        this.mdbDeliveryGroup(childKey, null);
        return (T)this;
    }

    public T mdbDeliveryGroup(MDBDeliveryGroupSupplier supplier) {
        this.mdbDeliveryGroup(supplier.get());
        return (T)this;
    }

    public T threadPools(List<ThreadPool> value) {
        this.subresources.threadPools = value;
        return (T)this;
    }

    public T threadPool(ThreadPool value) {
        this.subresources.threadPools.add(value);
        return (T)this;
    }

    public T threadPool(String childKey, ThreadPoolConsumer consumer) {
        ThreadPool child = new ThreadPool(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.threadPool(child);
        return (T)this;
    }

    public T threadPool(String childKey) {
        this.threadPool(childKey, null);
        return (T)this;
    }

    public T threadPool(ThreadPoolSupplier supplier) {
        this.threadPool(supplier.get());
        return (T)this;
    }

    public T filePassivationStores(List<FilePassivationStore> value) {
        this.subresources.filePassivationStores = value;
        return (T)this;
    }

    public T filePassivationStore(FilePassivationStore value) {
        this.subresources.filePassivationStores.add(value);
        return (T)this;
    }

    public T filePassivationStore(String childKey, FilePassivationStoreConsumer consumer) {
        FilePassivationStore child = new FilePassivationStore(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.filePassivationStore(child);
        return (T)this;
    }

    public T filePassivationStore(String childKey) {
        this.filePassivationStore(childKey, null);
        return (T)this;
    }

    public T filePassivationStore(FilePassivationStoreSupplier supplier) {
        this.filePassivationStore(supplier.get());
        return (T)this;
    }

    public T timerService(TimerService value) {
        this.subresources.timerService = value;
        return (T)this;
    }

    public T timerService(TimerServiceConsumer consumer) {
        TimerService child = new TimerService();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.timerService = child;
        return (T)this;
    }

    public T timerService() {
        TimerService child = new TimerService();
        this.subresources.timerService = child;
        return (T)this;
    }

    public T timerService(TimerServiceSupplier supplier) {
        this.subresources.timerService = supplier.get();
        return (T)this;
    }

    public T remoteService(RemoteService value) {
        this.subresources.remoteService = value;
        return (T)this;
    }

    public T remoteService(RemoteServiceConsumer consumer) {
        RemoteService child = new RemoteService();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.remoteService = child;
        return (T)this;
    }

    public T remoteService() {
        RemoteService child = new RemoteService();
        this.subresources.remoteService = child;
        return (T)this;
    }

    public T remoteService(RemoteServiceSupplier supplier) {
        this.subresources.remoteService = supplier.get();
        return (T)this;
    }

    public T asyncService(AsyncService value) {
        this.subresources.asyncService = value;
        return (T)this;
    }

    public T asyncService(AsyncServiceConsumer consumer) {
        AsyncService child = new AsyncService();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.asyncService = child;
        return (T)this;
    }

    public T asyncService() {
        AsyncService child = new AsyncService();
        this.subresources.asyncService = child;
        return (T)this;
    }

    public T asyncService(AsyncServiceSupplier supplier) {
        this.subresources.asyncService = supplier.get();
        return (T)this;
    }

    public T identityService(IdentityService value) {
        this.subresources.identityService = value;
        return (T)this;
    }

    public T identityService(IdentityServiceConsumer consumer) {
        IdentityService child = new IdentityService();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.identityService = child;
        return (T)this;
    }

    public T identityService() {
        IdentityService child = new IdentityService();
        this.subresources.identityService = child;
        return (T)this;
    }

    public T identityService(IdentityServiceSupplier supplier) {
        this.subresources.identityService = supplier.get();
        return (T)this;
    }

    public T iiopService(IIOPService value) {
        this.subresources.iiopService = value;
        return (T)this;
    }

    public T iiopService(IIOPServiceConsumer consumer) {
        IIOPService child = new IIOPService();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.iiopService = child;
        return (T)this;
    }

    public T iiopService() {
        IIOPService child = new IIOPService();
        this.subresources.iiopService = child;
        return (T)this;
    }

    public T iiopService(IIOPServiceSupplier supplier) {
        this.subresources.iiopService = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allow-ejb-name-regex")
    public Boolean allowEjbNameRegex() {
        return this.allowEjbNameRegex;
    }

    public T allowEjbNameRegex(Boolean value) {
        Boolean oldValue = this.allowEjbNameRegex;
        this.allowEjbNameRegex = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowEjbNameRegex", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="client-interceptors")
    public List<Map> clientInterceptors() {
        return this.clientInterceptors;
    }

    public T clientInterceptors(List<Map> value) {
        List<Map> oldValue = this.clientInterceptors;
        this.clientInterceptors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("clientInterceptors", oldValue, value);
        }
        return (T)this;
    }

    public T clientInterceptor(Map value) {
        if (this.clientInterceptors == null) {
            this.clientInterceptors = new ArrayList<Map>();
        }
        this.clientInterceptors.add(value);
        return (T)this;
    }

    public T clientInterceptors(Map ... args) {
        this.clientInterceptors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="default-clustered-sfsb-cache")
    public String defaultClusteredSfsbCache() {
        return this.defaultClusteredSfsbCache;
    }

    @Deprecated
    public T defaultClusteredSfsbCache(String value) {
        String oldValue = this.defaultClusteredSfsbCache;
        this.defaultClusteredSfsbCache = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultClusteredSfsbCache", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-distinct-name")
    public String defaultDistinctName() {
        return this.defaultDistinctName;
    }

    public T defaultDistinctName(String value) {
        String oldValue = this.defaultDistinctName;
        this.defaultDistinctName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultDistinctName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-entity-bean-instance-pool")
    public String defaultEntityBeanInstancePool() {
        return this.defaultEntityBeanInstancePool;
    }

    public T defaultEntityBeanInstancePool(String value) {
        String oldValue = this.defaultEntityBeanInstancePool;
        this.defaultEntityBeanInstancePool = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultEntityBeanInstancePool", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-entity-bean-optimistic-locking")
    public Boolean defaultEntityBeanOptimisticLocking() {
        return this.defaultEntityBeanOptimisticLocking;
    }

    public T defaultEntityBeanOptimisticLocking(Boolean value) {
        Boolean oldValue = this.defaultEntityBeanOptimisticLocking;
        this.defaultEntityBeanOptimisticLocking = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultEntityBeanOptimisticLocking", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-mdb-instance-pool")
    public String defaultMdbInstancePool() {
        return this.defaultMdbInstancePool;
    }

    public T defaultMdbInstancePool(String value) {
        String oldValue = this.defaultMdbInstancePool;
        this.defaultMdbInstancePool = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultMdbInstancePool", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-missing-method-permissions-deny-access")
    public Boolean defaultMissingMethodPermissionsDenyAccess() {
        return this.defaultMissingMethodPermissionsDenyAccess;
    }

    public T defaultMissingMethodPermissionsDenyAccess(Boolean value) {
        Boolean oldValue = this.defaultMissingMethodPermissionsDenyAccess;
        this.defaultMissingMethodPermissionsDenyAccess = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultMissingMethodPermissionsDenyAccess", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-resource-adapter-name")
    public String defaultResourceAdapterName() {
        return this.defaultResourceAdapterName;
    }

    public T defaultResourceAdapterName(String value) {
        String oldValue = this.defaultResourceAdapterName;
        this.defaultResourceAdapterName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultResourceAdapterName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-security-domain")
    public String defaultSecurityDomain() {
        return this.defaultSecurityDomain;
    }

    public T defaultSecurityDomain(String value) {
        String oldValue = this.defaultSecurityDomain;
        this.defaultSecurityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultSecurityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-sfsb-cache")
    public String defaultSfsbCache() {
        return this.defaultSfsbCache;
    }

    public T defaultSfsbCache(String value) {
        String oldValue = this.defaultSfsbCache;
        this.defaultSfsbCache = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultSfsbCache", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-sfsb-passivation-disabled-cache")
    public String defaultSfsbPassivationDisabledCache() {
        return this.defaultSfsbPassivationDisabledCache;
    }

    public T defaultSfsbPassivationDisabledCache(String value) {
        String oldValue = this.defaultSfsbPassivationDisabledCache;
        this.defaultSfsbPassivationDisabledCache = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultSfsbPassivationDisabledCache", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-singleton-bean-access-timeout")
    public Long defaultSingletonBeanAccessTimeout() {
        return this.defaultSingletonBeanAccessTimeout;
    }

    public T defaultSingletonBeanAccessTimeout(Long value) {
        Long oldValue = this.defaultSingletonBeanAccessTimeout;
        this.defaultSingletonBeanAccessTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultSingletonBeanAccessTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-slsb-instance-pool")
    public String defaultSlsbInstancePool() {
        return this.defaultSlsbInstancePool;
    }

    public T defaultSlsbInstancePool(String value) {
        String oldValue = this.defaultSlsbInstancePool;
        this.defaultSlsbInstancePool = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultSlsbInstancePool", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-stateful-bean-access-timeout")
    public Long defaultStatefulBeanAccessTimeout() {
        return this.defaultStatefulBeanAccessTimeout;
    }

    public T defaultStatefulBeanAccessTimeout(Long value) {
        Long oldValue = this.defaultStatefulBeanAccessTimeout;
        this.defaultStatefulBeanAccessTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultStatefulBeanAccessTimeout", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="disable-default-ejb-permissions")
    public Boolean disableDefaultEjbPermissions() {
        return this.disableDefaultEjbPermissions;
    }

    @Deprecated
    public T disableDefaultEjbPermissions(Boolean value) {
        Boolean oldValue = this.disableDefaultEjbPermissions;
        this.disableDefaultEjbPermissions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("disableDefaultEjbPermissions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-graceful-txn-shutdown")
    public Boolean enableGracefulTxnShutdown() {
        return this.enableGracefulTxnShutdown;
    }

    public T enableGracefulTxnShutdown(Boolean value) {
        Boolean oldValue = this.enableGracefulTxnShutdown;
        this.enableGracefulTxnShutdown = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableGracefulTxnShutdown", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="enable-statistics")
    public Boolean enableStatistics() {
        return this.enableStatistics;
    }

    @Deprecated
    public T enableStatistics(Boolean value) {
        Boolean oldValue = this.enableStatistics;
        this.enableStatistics = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableStatistics", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="in-vm-remote-interface-invocation-pass-by-value")
    public Boolean inVmRemoteInterfaceInvocationPassByValue() {
        return this.inVmRemoteInterfaceInvocationPassByValue;
    }

    public T inVmRemoteInterfaceInvocationPassByValue(Boolean value) {
        Boolean oldValue = this.inVmRemoteInterfaceInvocationPassByValue;
        this.inVmRemoteInterfaceInvocationPassByValue = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("inVmRemoteInterfaceInvocationPassByValue", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="log-system-exceptions")
    public Boolean logSystemExceptions() {
        return this.logSystemExceptions;
    }

    public T logSystemExceptions(Boolean value) {
        Boolean oldValue = this.logSystemExceptions;
        this.logSystemExceptions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("logSystemExceptions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-interceptors")
    public List<Map> serverInterceptors() {
        return this.serverInterceptors;
    }

    public T serverInterceptors(List<Map> value) {
        List<Map> oldValue = this.serverInterceptors;
        this.serverInterceptors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverInterceptors", oldValue, value);
        }
        return (T)this;
    }

    public T serverInterceptor(Map value) {
        if (this.serverInterceptors == null) {
            this.serverInterceptors = new ArrayList<Map>();
        }
        this.serverInterceptors.add(value);
        return (T)this;
    }

    public T serverInterceptors(Map ... args) {
        this.serverInterceptors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    public static class EJB3Resources {
        @ResourceDocumentation(value="A mapping from a security domain referenced in a deployed application")
        @SubresourceInfo(value="applicationSecurityDomain")
        private List<ApplicationSecurityDomain> applicationSecurityDomains = new ArrayList<ApplicationSecurityDomain>();
        @ResourceDocumentation(value="A bean instance pool with a strict upper limit")
        @SubresourceInfo(value="strictMaxBeanInstancePool")
        private List<StrictMaxBeanInstancePool> strictMaxBeanInstancePools = new ArrayList<StrictMaxBeanInstancePool>();
        @ResourceDocumentation(value="A SFSB cache")
        @SubresourceInfo(value="cache")
        private List<Cache> caches = new ArrayList<Cache>();
        @ResourceDocumentation(value="A remoting profile")
        @SubresourceInfo(value="remotingProfile")
        private List<RemotingProfile> remotingProfiles = new ArrayList<RemotingProfile>();
        @ResourceDocumentation(value="A clustered passivation store")
        @SubresourceInfo(value="clusterPassivationStore")
        private List<ClusterPassivationStore> clusterPassivationStores = new ArrayList<ClusterPassivationStore>();
        @ResourceDocumentation(value="A passivation store")
        @SubresourceInfo(value="passivationStore")
        private List<PassivationStore> passivationStores = new ArrayList<PassivationStore>();
        @ResourceDocumentation(value="Delivery group to manage delivery for mdbs")
        @SubresourceInfo(value="mdbDeliveryGroup")
        private List<MDBDeliveryGroup> mdbDeliveryGroups = new ArrayList<MDBDeliveryGroup>();
        @ResourceDocumentation(value="A thread pool executor with an enhanced queue.  In such a thread pool, its core and max size are configured independently, idle threads are always reused when available, and threads count is kept to a minimum.")
        @SubresourceInfo(value="threadPool")
        private List<ThreadPool> threadPools = new ArrayList<ThreadPool>();
        @ResourceDocumentation(value="A file system based passivation store")
        @SubresourceInfo(value="filePassivationStore")
        private List<FilePassivationStore> filePassivationStores = new ArrayList<FilePassivationStore>();
        @SingletonResource
        @ResourceDocumentation(value="The EJB timer service")
        private TimerService timerService;
        @SingletonResource
        @ResourceDocumentation(value="The EJB3 Remote Service")
        private RemoteService remoteService;
        @SingletonResource
        @ResourceDocumentation(value="The EJB3 Asynchronous Invocation Service")
        private AsyncService asyncService;
        @SingletonResource
        @ResourceDocumentation(value="Identity definition for security identity propagation")
        private IdentityService identityService;
        @SingletonResource
        @ResourceDocumentation(value="The IIOP service")
        private IIOPService iiopService;

        @Subresource
        public List<ApplicationSecurityDomain> applicationSecurityDomains() {
            return this.applicationSecurityDomains;
        }

        public ApplicationSecurityDomain applicationSecurityDomain(String key) {
            return this.applicationSecurityDomains.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<StrictMaxBeanInstancePool> strictMaxBeanInstancePools() {
            return this.strictMaxBeanInstancePools;
        }

        public StrictMaxBeanInstancePool strictMaxBeanInstancePool(String key) {
            return this.strictMaxBeanInstancePools.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Cache> caches() {
            return this.caches;
        }

        public Cache cache(String key) {
            return this.caches.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RemotingProfile> remotingProfiles() {
            return this.remotingProfiles;
        }

        public RemotingProfile remotingProfile(String key) {
            return this.remotingProfiles.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ClusterPassivationStore> clusterPassivationStores() {
            return this.clusterPassivationStores;
        }

        public ClusterPassivationStore clusterPassivationStore(String key) {
            return this.clusterPassivationStores.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<PassivationStore> passivationStores() {
            return this.passivationStores;
        }

        public PassivationStore passivationStore(String key) {
            return this.passivationStores.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<MDBDeliveryGroup> mdbDeliveryGroups() {
            return this.mdbDeliveryGroups;
        }

        public MDBDeliveryGroup mdbDeliveryGroup(String key) {
            return this.mdbDeliveryGroups.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ThreadPool> threadPools() {
            return this.threadPools;
        }

        public ThreadPool threadPool(String key) {
            return this.threadPools.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<FilePassivationStore> filePassivationStores() {
            return this.filePassivationStores;
        }

        public FilePassivationStore filePassivationStore(String key) {
            return this.filePassivationStores.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public TimerService timerService() {
            return this.timerService;
        }

        @Subresource
        public RemoteService remoteService() {
            return this.remoteService;
        }

        @Subresource
        public AsyncService asyncService() {
            return this.asyncService;
        }

        @Subresource
        public IdentityService identityService() {
            return this.identityService;
        }

        @Subresource
        public IIOPService iiopService() {
            return this.iiopService;
        }
    }
}

