/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.messaging.activemq.ConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.ConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.ConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.Connector;
import org.wildfly.swarm.config.messaging.activemq.ConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.ConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.DiscoveryGroup;
import org.wildfly.swarm.config.messaging.activemq.DiscoveryGroupConsumer;
import org.wildfly.swarm.config.messaging.activemq.DiscoveryGroupSupplier;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSQueue;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSQueueSupplier;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSTopic;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSTopicConsumer;
import org.wildfly.swarm.config.messaging.activemq.ExternalJMSTopicSupplier;
import org.wildfly.swarm.config.messaging.activemq.HTTPConnector;
import org.wildfly.swarm.config.messaging.activemq.HTTPConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.HTTPConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.InVMConnector;
import org.wildfly.swarm.config.messaging.activemq.InVMConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.InVMConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.JMSBridge;
import org.wildfly.swarm.config.messaging.activemq.JMSBridgeConsumer;
import org.wildfly.swarm.config.messaging.activemq.JMSBridgeSupplier;
import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactoryConsumer;
import org.wildfly.swarm.config.messaging.activemq.PooledConnectionFactorySupplier;
import org.wildfly.swarm.config.messaging.activemq.RemoteConnector;
import org.wildfly.swarm.config.messaging.activemq.RemoteConnectorConsumer;
import org.wildfly.swarm.config.messaging.activemq.RemoteConnectorSupplier;
import org.wildfly.swarm.config.messaging.activemq.Server;
import org.wildfly.swarm.config.messaging.activemq.ServerConsumer;
import org.wildfly.swarm.config.messaging.activemq.ServerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=messaging-activemq")
@ResourceType(value="subsystem")
@Implicit
public class MessagingActiveMQ<T extends MessagingActiveMQ<T>>
implements Keyed {
    private String key = "messaging-activemq";
    private PropertyChangeSupport pcs;
    private MessagingActiveMQResources subresources = new MessagingActiveMQResources();
    @AttributeDocumentation(value="The approximate number of threads used by all ActiveMQ clients that are actively executing tasks.")
    private Integer globalClientScheduledThreadPoolActiveCount;
    @AttributeDocumentation(value="The approximate number of tasks that have been executed by all ActiveMQ clients.")
    private Integer globalClientScheduledThreadPoolCompletedTaskCount;
    @AttributeDocumentation(value="The current number of threads in the pool used by all ActiveMQ clients.")
    private Integer globalClientScheduledThreadPoolCurrentThreadCount;
    @AttributeDocumentation(value="The amount of time that pool threads should be kept running when idle.")
    private Long globalClientScheduledThreadPoolKeepaliveTime;
    @AttributeDocumentation(value="The largest number of threads that have ever simultaneously been in the pool used by all ActiveMQ clients.")
    private Integer globalClientScheduledThreadPoolLargestThreadCount;
    @AttributeDocumentation(value="Maximum size of the pool of threads used by all ActiveMQ clients running inside this server. If the attribute is undefined (by default), ActiveMQ will configure it to be 8 x the number of available processors.")
    private Integer globalClientScheduledThreadPoolMaxSize;
    @AttributeDocumentation(value="The approximate total number of tasks that have ever been scheduled by all ActiveMQ clients.")
    private Integer globalClientScheduledThreadPoolTaskCount;
    @AttributeDocumentation(value="The approximate number of threads used by all ActiveMQ clients that are actively executing tasks.")
    private Integer globalClientThreadPoolActiveCount;
    @AttributeDocumentation(value="The approximate number of tasks that have been executed by all ActiveMQ clients.")
    private Integer globalClientThreadPoolCompletedTaskCount;
    @AttributeDocumentation(value="The current number of threads in the pool used by all ActiveMQ clients.")
    private Integer globalClientThreadPoolCurrentThreadCount;
    @AttributeDocumentation(value="The amount of time that pool threads should be kept running when idle.")
    private Long globalClientThreadPoolKeepaliveTime;
    @AttributeDocumentation(value="The largest number of threads that have ever simultaneously been in the pool used by all ActiveMQ clients.")
    private Integer globalClientThreadPoolLargestThreadCount;
    @AttributeDocumentation(value="Maximum size of the pool of scheduled threads used by all ActiveMQ clients running inside this server.")
    private Integer globalClientThreadPoolMaxSize;
    @AttributeDocumentation(value="The approximate total number of tasks that have ever been scheduled by all ActiveMQ clients.")
    private Integer globalClientThreadPoolTaskCount;

    public MessagingActiveMQ() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public MessagingActiveMQResources subresources() {
        return this.subresources;
    }

    public T discoveryGroups(List<DiscoveryGroup> value) {
        this.subresources.discoveryGroups = value;
        return (T)this;
    }

    public T discoveryGroup(DiscoveryGroup value) {
        this.subresources.discoveryGroups.add(value);
        return (T)this;
    }

    public T discoveryGroup(String childKey, DiscoveryGroupConsumer consumer) {
        DiscoveryGroup child = new DiscoveryGroup(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.discoveryGroup(child);
        return (T)this;
    }

    public T discoveryGroup(String childKey) {
        this.discoveryGroup(childKey, null);
        return (T)this;
    }

    public T discoveryGroup(DiscoveryGroupSupplier supplier) {
        this.discoveryGroup(supplier.get());
        return (T)this;
    }

    public T httpConnectors(List<HTTPConnector> value) {
        this.subresources.httpConnectors = value;
        return (T)this;
    }

    public T httpConnector(HTTPConnector value) {
        this.subresources.httpConnectors.add(value);
        return (T)this;
    }

    public T httpConnector(String childKey, HTTPConnectorConsumer consumer) {
        HTTPConnector child = new HTTPConnector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.httpConnector(child);
        return (T)this;
    }

    public T httpConnector(String childKey) {
        this.httpConnector(childKey, null);
        return (T)this;
    }

    public T httpConnector(HTTPConnectorSupplier supplier) {
        this.httpConnector(supplier.get());
        return (T)this;
    }

    public T pooledConnectionFactories(List<PooledConnectionFactory> value) {
        this.subresources.pooledConnectionFactories = value;
        return (T)this;
    }

    public T pooledConnectionFactory(PooledConnectionFactory value) {
        this.subresources.pooledConnectionFactories.add(value);
        return (T)this;
    }

    public T pooledConnectionFactory(String childKey, PooledConnectionFactoryConsumer consumer) {
        PooledConnectionFactory child = new PooledConnectionFactory(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.pooledConnectionFactory(child);
        return (T)this;
    }

    public T pooledConnectionFactory(String childKey) {
        this.pooledConnectionFactory(childKey, null);
        return (T)this;
    }

    public T pooledConnectionFactory(PooledConnectionFactorySupplier supplier) {
        this.pooledConnectionFactory(supplier.get());
        return (T)this;
    }

    public T servers(List<Server> value) {
        this.subresources.servers = value;
        return (T)this;
    }

    public T server(Server value) {
        this.subresources.servers.add(value);
        return (T)this;
    }

    public T server(String childKey, ServerConsumer consumer) {
        Server child = new Server(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.server(child);
        return (T)this;
    }

    public T server(String childKey) {
        this.server(childKey, null);
        return (T)this;
    }

    public T server(ServerSupplier supplier) {
        this.server(supplier.get());
        return (T)this;
    }

    public T connectors(List<Connector> value) {
        this.subresources.connectors = value;
        return (T)this;
    }

    public T connector(Connector value) {
        this.subresources.connectors.add(value);
        return (T)this;
    }

    public T connector(String childKey, ConnectorConsumer consumer) {
        Connector child = new Connector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connector(child);
        return (T)this;
    }

    public T connector(String childKey) {
        this.connector(childKey, null);
        return (T)this;
    }

    public T connector(ConnectorSupplier supplier) {
        this.connector(supplier.get());
        return (T)this;
    }

    public T connectionFactories(List<ConnectionFactory> value) {
        this.subresources.connectionFactories = value;
        return (T)this;
    }

    public T connectionFactory(ConnectionFactory value) {
        this.subresources.connectionFactories.add(value);
        return (T)this;
    }

    public T connectionFactory(String childKey, ConnectionFactoryConsumer consumer) {
        ConnectionFactory child = new ConnectionFactory(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connectionFactory(child);
        return (T)this;
    }

    public T connectionFactory(String childKey) {
        this.connectionFactory(childKey, null);
        return (T)this;
    }

    public T connectionFactory(ConnectionFactorySupplier supplier) {
        this.connectionFactory(supplier.get());
        return (T)this;
    }

    public T remoteConnectors(List<RemoteConnector> value) {
        this.subresources.remoteConnectors = value;
        return (T)this;
    }

    public T remoteConnector(RemoteConnector value) {
        this.subresources.remoteConnectors.add(value);
        return (T)this;
    }

    public T remoteConnector(String childKey, RemoteConnectorConsumer consumer) {
        RemoteConnector child = new RemoteConnector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.remoteConnector(child);
        return (T)this;
    }

    public T remoteConnector(String childKey) {
        this.remoteConnector(childKey, null);
        return (T)this;
    }

    public T remoteConnector(RemoteConnectorSupplier supplier) {
        this.remoteConnector(supplier.get());
        return (T)this;
    }

    public T inVmConnectors(List<InVMConnector> value) {
        this.subresources.inVmConnectors = value;
        return (T)this;
    }

    public T inVmConnector(InVMConnector value) {
        this.subresources.inVmConnectors.add(value);
        return (T)this;
    }

    public T inVmConnector(String childKey, InVMConnectorConsumer consumer) {
        InVMConnector child = new InVMConnector(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.inVmConnector(child);
        return (T)this;
    }

    public T inVmConnector(String childKey) {
        this.inVmConnector(childKey, null);
        return (T)this;
    }

    public T inVmConnector(InVMConnectorSupplier supplier) {
        this.inVmConnector(supplier.get());
        return (T)this;
    }

    public T jmsBridges(List<JMSBridge> value) {
        this.subresources.jmsBridges = value;
        return (T)this;
    }

    public T jmsBridge(JMSBridge value) {
        this.subresources.jmsBridges.add(value);
        return (T)this;
    }

    public T jmsBridge(String childKey, JMSBridgeConsumer consumer) {
        JMSBridge child = new JMSBridge(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jmsBridge(child);
        return (T)this;
    }

    public T jmsBridge(String childKey) {
        this.jmsBridge(childKey, null);
        return (T)this;
    }

    public T jmsBridge(JMSBridgeSupplier supplier) {
        this.jmsBridge(supplier.get());
        return (T)this;
    }

    public T externalJmsQueues(List<ExternalJMSQueue> value) {
        this.subresources.externalJmsQueues = value;
        return (T)this;
    }

    public T externalJmsQueue(ExternalJMSQueue value) {
        this.subresources.externalJmsQueues.add(value);
        return (T)this;
    }

    public T externalJmsQueue(String childKey, ExternalJMSQueueConsumer consumer) {
        ExternalJMSQueue child = new ExternalJMSQueue(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.externalJmsQueue(child);
        return (T)this;
    }

    public T externalJmsQueue(String childKey) {
        this.externalJmsQueue(childKey, null);
        return (T)this;
    }

    public T externalJmsQueue(ExternalJMSQueueSupplier supplier) {
        this.externalJmsQueue(supplier.get());
        return (T)this;
    }

    public T externalJmsTopics(List<ExternalJMSTopic> value) {
        this.subresources.externalJmsTopics = value;
        return (T)this;
    }

    public T externalJmsTopic(ExternalJMSTopic value) {
        this.subresources.externalJmsTopics.add(value);
        return (T)this;
    }

    public T externalJmsTopic(String childKey, ExternalJMSTopicConsumer consumer) {
        ExternalJMSTopic child = new ExternalJMSTopic(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.externalJmsTopic(child);
        return (T)this;
    }

    public T externalJmsTopic(String childKey) {
        this.externalJmsTopic(childKey, null);
        return (T)this;
    }

    public T externalJmsTopic(ExternalJMSTopicSupplier supplier) {
        this.externalJmsTopic(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-scheduled-thread-pool-active-count")
    public Integer globalClientScheduledThreadPoolActiveCount() {
        return this.globalClientScheduledThreadPoolActiveCount;
    }

    public T globalClientScheduledThreadPoolActiveCount(Integer value) {
        Integer oldValue = this.globalClientScheduledThreadPoolActiveCount;
        this.globalClientScheduledThreadPoolActiveCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientScheduledThreadPoolActiveCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-scheduled-thread-pool-completed-task-count")
    public Integer globalClientScheduledThreadPoolCompletedTaskCount() {
        return this.globalClientScheduledThreadPoolCompletedTaskCount;
    }

    public T globalClientScheduledThreadPoolCompletedTaskCount(Integer value) {
        Integer oldValue = this.globalClientScheduledThreadPoolCompletedTaskCount;
        this.globalClientScheduledThreadPoolCompletedTaskCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientScheduledThreadPoolCompletedTaskCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-scheduled-thread-pool-current-thread-count")
    public Integer globalClientScheduledThreadPoolCurrentThreadCount() {
        return this.globalClientScheduledThreadPoolCurrentThreadCount;
    }

    public T globalClientScheduledThreadPoolCurrentThreadCount(Integer value) {
        Integer oldValue = this.globalClientScheduledThreadPoolCurrentThreadCount;
        this.globalClientScheduledThreadPoolCurrentThreadCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientScheduledThreadPoolCurrentThreadCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-scheduled-thread-pool-keepalive-time")
    public Long globalClientScheduledThreadPoolKeepaliveTime() {
        return this.globalClientScheduledThreadPoolKeepaliveTime;
    }

    public T globalClientScheduledThreadPoolKeepaliveTime(Long value) {
        Long oldValue = this.globalClientScheduledThreadPoolKeepaliveTime;
        this.globalClientScheduledThreadPoolKeepaliveTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientScheduledThreadPoolKeepaliveTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-scheduled-thread-pool-largest-thread-count")
    public Integer globalClientScheduledThreadPoolLargestThreadCount() {
        return this.globalClientScheduledThreadPoolLargestThreadCount;
    }

    public T globalClientScheduledThreadPoolLargestThreadCount(Integer value) {
        Integer oldValue = this.globalClientScheduledThreadPoolLargestThreadCount;
        this.globalClientScheduledThreadPoolLargestThreadCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientScheduledThreadPoolLargestThreadCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-scheduled-thread-pool-max-size")
    public Integer globalClientScheduledThreadPoolMaxSize() {
        return this.globalClientScheduledThreadPoolMaxSize;
    }

    public T globalClientScheduledThreadPoolMaxSize(Integer value) {
        Integer oldValue = this.globalClientScheduledThreadPoolMaxSize;
        this.globalClientScheduledThreadPoolMaxSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientScheduledThreadPoolMaxSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-scheduled-thread-pool-task-count")
    public Integer globalClientScheduledThreadPoolTaskCount() {
        return this.globalClientScheduledThreadPoolTaskCount;
    }

    public T globalClientScheduledThreadPoolTaskCount(Integer value) {
        Integer oldValue = this.globalClientScheduledThreadPoolTaskCount;
        this.globalClientScheduledThreadPoolTaskCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientScheduledThreadPoolTaskCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-thread-pool-active-count")
    public Integer globalClientThreadPoolActiveCount() {
        return this.globalClientThreadPoolActiveCount;
    }

    public T globalClientThreadPoolActiveCount(Integer value) {
        Integer oldValue = this.globalClientThreadPoolActiveCount;
        this.globalClientThreadPoolActiveCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientThreadPoolActiveCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-thread-pool-completed-task-count")
    public Integer globalClientThreadPoolCompletedTaskCount() {
        return this.globalClientThreadPoolCompletedTaskCount;
    }

    public T globalClientThreadPoolCompletedTaskCount(Integer value) {
        Integer oldValue = this.globalClientThreadPoolCompletedTaskCount;
        this.globalClientThreadPoolCompletedTaskCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientThreadPoolCompletedTaskCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-thread-pool-current-thread-count")
    public Integer globalClientThreadPoolCurrentThreadCount() {
        return this.globalClientThreadPoolCurrentThreadCount;
    }

    public T globalClientThreadPoolCurrentThreadCount(Integer value) {
        Integer oldValue = this.globalClientThreadPoolCurrentThreadCount;
        this.globalClientThreadPoolCurrentThreadCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientThreadPoolCurrentThreadCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-thread-pool-keepalive-time")
    public Long globalClientThreadPoolKeepaliveTime() {
        return this.globalClientThreadPoolKeepaliveTime;
    }

    public T globalClientThreadPoolKeepaliveTime(Long value) {
        Long oldValue = this.globalClientThreadPoolKeepaliveTime;
        this.globalClientThreadPoolKeepaliveTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientThreadPoolKeepaliveTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-thread-pool-largest-thread-count")
    public Integer globalClientThreadPoolLargestThreadCount() {
        return this.globalClientThreadPoolLargestThreadCount;
    }

    public T globalClientThreadPoolLargestThreadCount(Integer value) {
        Integer oldValue = this.globalClientThreadPoolLargestThreadCount;
        this.globalClientThreadPoolLargestThreadCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientThreadPoolLargestThreadCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-thread-pool-max-size")
    public Integer globalClientThreadPoolMaxSize() {
        return this.globalClientThreadPoolMaxSize;
    }

    public T globalClientThreadPoolMaxSize(Integer value) {
        Integer oldValue = this.globalClientThreadPoolMaxSize;
        this.globalClientThreadPoolMaxSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientThreadPoolMaxSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-thread-pool-task-count")
    public Integer globalClientThreadPoolTaskCount() {
        return this.globalClientThreadPoolTaskCount;
    }

    public T globalClientThreadPoolTaskCount(Integer value) {
        Integer oldValue = this.globalClientThreadPoolTaskCount;
        this.globalClientThreadPoolTaskCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientThreadPoolTaskCount", oldValue, value);
        }
        return (T)this;
    }

    public static class MessagingActiveMQResources {
        @ResourceDocumentation(value="Multicast group to listen to receive broadcast from other servers announcing their connectors.")
        @SubresourceInfo(value="discoveryGroup")
        private List<DiscoveryGroup> discoveryGroups = new ArrayList<DiscoveryGroup>();
        @ResourceDocumentation(value="Used by a remote client to define how it connects to a server over HTTP.")
        @SubresourceInfo(value="httpConnector")
        private List<HTTPConnector> httpConnectors = new ArrayList<HTTPConnector>();
        @ResourceDocumentation(value="Defines a managed connection factory.")
        @SubresourceInfo(value="pooledConnectionFactory")
        private List<PooledConnectionFactory> pooledConnectionFactories = new ArrayList<PooledConnectionFactory>();
        @ResourceDocumentation(value="An ActiveMQ server instance.")
        @SubresourceInfo(value="server")
        private List<Server> servers = new ArrayList<Server>();
        @ResourceDocumentation(value="A connector can be used by a client to define how it connects to a server.")
        @SubresourceInfo(value="connector")
        private List<Connector> connectors = new ArrayList<Connector>();
        @ResourceDocumentation(value="Defines a connection factory.")
        @SubresourceInfo(value="connectionFactory")
        private List<ConnectionFactory> connectionFactories = new ArrayList<ConnectionFactory>();
        @ResourceDocumentation(value="Used by a remote client to define how it connects to a server.")
        @SubresourceInfo(value="remoteConnector")
        private List<RemoteConnector> remoteConnectors = new ArrayList<RemoteConnector>();
        @ResourceDocumentation(value="Used by an in-VM client to define how it connects to a server.")
        @SubresourceInfo(value="inVmConnector")
        private List<InVMConnector> inVmConnectors = new ArrayList<InVMConnector>();
        @ResourceDocumentation(value="A JMS bridge instance.")
        @SubresourceInfo(value="jmsBridge")
        private List<JMSBridge> jmsBridges = new ArrayList<JMSBridge>();
        @ResourceDocumentation(value="Defines a JMS queue to a remote broker.")
        @SubresourceInfo(value="externalJmsQueue")
        private List<ExternalJMSQueue> externalJmsQueues = new ArrayList<ExternalJMSQueue>();
        @ResourceDocumentation(value="Defines a JMS topic to a remote broker.")
        @SubresourceInfo(value="externalJmsTopic")
        private List<ExternalJMSTopic> externalJmsTopics = new ArrayList<ExternalJMSTopic>();

        @Subresource
        public List<DiscoveryGroup> discoveryGroups() {
            return this.discoveryGroups;
        }

        public DiscoveryGroup discoveryGroup(String key) {
            return this.discoveryGroups.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<HTTPConnector> httpConnectors() {
            return this.httpConnectors;
        }

        public HTTPConnector httpConnector(String key) {
            return this.httpConnectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<PooledConnectionFactory> pooledConnectionFactories() {
            return this.pooledConnectionFactories;
        }

        public PooledConnectionFactory pooledConnectionFactory(String key) {
            return this.pooledConnectionFactories.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Server> servers() {
            return this.servers;
        }

        public Server server(String key) {
            return this.servers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<Connector> connectors() {
            return this.connectors;
        }

        public Connector connector(String key) {
            return this.connectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ConnectionFactory> connectionFactories() {
            return this.connectionFactories;
        }

        public ConnectionFactory connectionFactory(String key) {
            return this.connectionFactories.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RemoteConnector> remoteConnectors() {
            return this.remoteConnectors;
        }

        public RemoteConnector remoteConnector(String key) {
            return this.remoteConnectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<InVMConnector> inVmConnectors() {
            return this.inVmConnectors;
        }

        public InVMConnector inVmConnector(String key) {
            return this.inVmConnectors.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<JMSBridge> jmsBridges() {
            return this.jmsBridges;
        }

        public JMSBridge jmsBridge(String key) {
            return this.jmsBridges.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ExternalJMSQueue> externalJmsQueues() {
            return this.externalJmsQueues;
        }

        public ExternalJMSQueue externalJmsQueue(String key) {
            return this.externalJmsQueues.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ExternalJMSTopic> externalJmsTopics() {
            return this.externalJmsTopics;
        }

        public ExternalJMSTopic externalJmsTopic(String key) {
            return this.externalJmsTopics.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

