/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.transactions.CommitMarkableResource;
import org.wildfly.swarm.config.transactions.CommitMarkableResourceConsumer;
import org.wildfly.swarm.config.transactions.CommitMarkableResourceSupplier;
import org.wildfly.swarm.config.transactions.LogStore;
import org.wildfly.swarm.config.transactions.LogStoreConsumer;
import org.wildfly.swarm.config.transactions.LogStoreSupplier;

@Address(value="/subsystem=transactions")
@ResourceType(value="subsystem")
@Implicit
public class Transactions<T extends Transactions<T>>
implements Keyed {
    private String key = "transactions";
    private PropertyChangeSupport pcs;
    private TransactionsResources subresources = new TransactionsResources();
    @AttributeDocumentation(value="The average time of transaction commit, measured from the moment the client calls commit until the transaction manager determines that the commit attempt was successful.")
    private Long averageCommitTime;
    @AttributeDocumentation(value="The default timeout for a transaction managed by the transaction manager.")
    private Integer defaultTimeout;
    @AttributeDocumentation(value="Whether transaction statistics should be gathered.")
    private Boolean enableStatistics;
    @AttributeDocumentation(value="Whether the transaction status manager (TSM) service, needed for out of process recovery, should be provided or not.")
    private Boolean enableTsmStatus;
    @AttributeDocumentation(value="Whether AsyncIO should be enabled for the journal store.")
    private Boolean hornetqStoreEnableAsyncIo;
    @AttributeDocumentation(value="Configure if jdbc action store should drop tables.")
    private Boolean jdbcActionStoreDropTable;
    @AttributeDocumentation(value="Optional prefix for table used to write transaction logs in configured jdbc action store.")
    private String jdbcActionStoreTablePrefix;
    @AttributeDocumentation(value="Configure if jdbc communication store should drop tables.")
    private Boolean jdbcCommunicationStoreDropTable;
    @AttributeDocumentation(value="Optional prefix for table used to write transaction logs in configured jdbc communication store.")
    private String jdbcCommunicationStoreTablePrefix;
    @AttributeDocumentation(value="Configure if jdbc state store should drop tables.")
    private Boolean jdbcStateStoreDropTable;
    @AttributeDocumentation(value="Optional prefix for table used to write transaction logs in configured jdbc state store.")
    private String jdbcStateStoreTablePrefix;
    @AttributeDocumentation(value="Jndi name of non-XA datasource used. Datasource sghould be define in datasources subsystem. For this would work the non-XA datasource has to be marked as jta=\"false\".")
    private String jdbcStoreDatasource;
    @AttributeDocumentation(value="Whether AsyncIO should be enabled for the journal store. For this settings being active journal natives libraries needs to be available.")
    private Boolean journalStoreEnableAsyncIo;
    @AttributeDocumentation(value="If true this enables the Java Transaction Service. Use of the JTS needs configuration in IIOP OpenJDK where Transactions parameter needs to be set to full.")
    private Boolean jts;
    @AttributeDocumentation(value="If the default timeout is zero then this value is consulted to set the maximum timeout (in seconds) for a transaction managed by the transaction manager.")
    private Integer maximumTimeout;
    @AttributeDocumentation(value="Used to set the node identifier on the core environment. Each Xid that Transaction Manager creates will have this identifier encoded within it and ensures Transaction Manager will only recover branches which match the specified identifier. It is imperative that this identifier is unique between Application Server instances which share either an object store or access common resource managers.")
    private String nodeIdentifier;
    @AttributeDocumentation(value="The number of aborted (i.e. rolledback) transactions.")
    private Long numberOfAbortedTransactions;
    @AttributeDocumentation(value="The number of transactions that have been rolled back by application request. This includes those that timeout, since the timeout behavior is considered an attribute of the application configuration.")
    private Long numberOfApplicationRollbacks;
    @AttributeDocumentation(value="The number of committed transactions.")
    private Long numberOfCommittedTransactions;
    @AttributeDocumentation(value="The number of transactions which have terminated with heuristic outcomes.")
    private Long numberOfHeuristics;
    @AttributeDocumentation(value="The number of transactions that have begun but not yet terminated.")
    private Long numberOfInflightTransactions;
    @AttributeDocumentation(value="The total number of nested (sub) transactions created.")
    private Long numberOfNestedTransactions;
    @AttributeDocumentation(value="The number of transactions that rolled back due to resource (participant) failure.")
    private Long numberOfResourceRollbacks;
    @AttributeDocumentation(value="The number of transactions that have been rolled back due to internal system errors.")
    private Long numberOfSystemRollbacks;
    @AttributeDocumentation(value="The number of transactions that have rolled back due to timeout.")
    private Long numberOfTimedOutTransactions;
    @AttributeDocumentation(value="The total number of transactions (top-level and nested) created")
    private Long numberOfTransactions;
    @AttributeDocumentation(value="Denotes a relative or absolute filesystem path denoting where the transaction manager object store should store data. By default the value is treated as relative to the path denoted by the \"relative-to\" attribute. This settings is valid when default or journal store is used. It's not used when jdbc journal store is used.")
    private String objectStorePath;
    @AttributeDocumentation(value="References a global path configuration in the domain model, defaulting to the Application Server data directory (jboss.server.data.dir). The value of the \"Object store path\" attribute will treated as relative to this path. Undefine this attribute to disable the default behavior and force the value of the \"Object store path\" attribute to be treated as an absolute path.")
    private String objectStoreRelativeTo;
    @AttributeDocumentation(value="The name of the socket binding configuration to use if the transaction manager should use a socket-based process id. Will be 'undefined' if 'process-id-uuid' is 'true'; otherwise must be set.")
    private String processIdSocketBinding;
    @AttributeDocumentation(value="The maximum number of ports to search for an open port if the transaction manager should use a socket-based process id. If the port specified by the socket binding referenced in 'process-id-socket-binding' is occupied, the next higher port will be tried until an open port is found or the number of ports specified by this attribute have been tried. Will be 'undefined' if 'process-id-uuid' is 'true'.")
    private Integer processIdSocketMaxPorts;
    @AttributeDocumentation(value="Indicates whether the transaction manager should use a UUID based process id.")
    private Boolean processIdUuid;
    @AttributeDocumentation(value="Used to specify if the recovery system should listen on a network socket or not.")
    private Boolean recoveryListener;
    @AttributeDocumentation(value="Used to reference the correct socket binding to use for the recovery environment.")
    private String socketBinding;
    @AttributeDocumentation(value="Whether transaction statistics should be gathered.")
    private Boolean statisticsEnabled;
    @AttributeDocumentation(value="Used to reference the correct socket binding to use for the transaction status manager.")
    private String statusSocketBinding;
    @AttributeDocumentation(value="Use the journal store for writing transaction logs. Set to true to enable and to false to use the default log store type. The default log store is normally one file system file per transaction log.It's alternative to jdbc based store.")
    private Boolean useHornetqStore;
    @AttributeDocumentation(value="Use the jdbc store for writing transaction logs. Set to true to enable and to false to use the default log store type. The default log store is normally one file file per transaction log. It's alternative to journal based store.")
    private Boolean useJdbcStore;
    @AttributeDocumentation(value="Use the journal store for writing transaction logs. Set to true to enable and to false to use the default log store type. The default log store creates normally one file system file per transaction log. The journal one consists from one file for all the transactions. It's alternative to jdbc based store.")
    private Boolean useJournalStore;

    public Transactions() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public TransactionsResources subresources() {
        return this.subresources;
    }

    public T commitMarkableResources(List<CommitMarkableResource> value) {
        this.subresources.commitMarkableResources = value;
        return (T)this;
    }

    public T commitMarkableResource(CommitMarkableResource value) {
        this.subresources.commitMarkableResources.add(value);
        return (T)this;
    }

    public T commitMarkableResource(String childKey, CommitMarkableResourceConsumer consumer) {
        CommitMarkableResource child = new CommitMarkableResource(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.commitMarkableResource(child);
        return (T)this;
    }

    public T commitMarkableResource(String childKey) {
        this.commitMarkableResource(childKey, null);
        return (T)this;
    }

    public T commitMarkableResource(CommitMarkableResourceSupplier supplier) {
        this.commitMarkableResource(supplier.get());
        return (T)this;
    }

    public T logStore(LogStore value) {
        this.subresources.logStore = value;
        return (T)this;
    }

    public T logStore(LogStoreConsumer consumer) {
        LogStore child = new LogStore();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.logStore = child;
        return (T)this;
    }

    public T logStore() {
        LogStore child = new LogStore();
        this.subresources.logStore = child;
        return (T)this;
    }

    public T logStore(LogStoreSupplier supplier) {
        this.subresources.logStore = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="average-commit-time")
    public Long averageCommitTime() {
        return this.averageCommitTime;
    }

    public T averageCommitTime(Long value) {
        Long oldValue = this.averageCommitTime;
        this.averageCommitTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("averageCommitTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-timeout")
    public Integer defaultTimeout() {
        return this.defaultTimeout;
    }

    public T defaultTimeout(Integer value) {
        Integer oldValue = this.defaultTimeout;
        this.defaultTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultTimeout", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="enable-statistics")
    public Boolean enableStatistics() {
        return this.enableStatistics;
    }

    @Deprecated
    public T enableStatistics(Boolean value) {
        Boolean oldValue = this.enableStatistics;
        this.enableStatistics = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableStatistics", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-tsm-status")
    public Boolean enableTsmStatus() {
        return this.enableTsmStatus;
    }

    public T enableTsmStatus(Boolean value) {
        Boolean oldValue = this.enableTsmStatus;
        this.enableTsmStatus = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableTsmStatus", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="hornetq-store-enable-async-io")
    public Boolean hornetqStoreEnableAsyncIo() {
        return this.hornetqStoreEnableAsyncIo;
    }

    @Deprecated
    public T hornetqStoreEnableAsyncIo(Boolean value) {
        Boolean oldValue = this.hornetqStoreEnableAsyncIo;
        this.hornetqStoreEnableAsyncIo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("hornetqStoreEnableAsyncIo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-action-store-drop-table")
    public Boolean jdbcActionStoreDropTable() {
        return this.jdbcActionStoreDropTable;
    }

    public T jdbcActionStoreDropTable(Boolean value) {
        Boolean oldValue = this.jdbcActionStoreDropTable;
        this.jdbcActionStoreDropTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcActionStoreDropTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-action-store-table-prefix")
    public String jdbcActionStoreTablePrefix() {
        return this.jdbcActionStoreTablePrefix;
    }

    public T jdbcActionStoreTablePrefix(String value) {
        String oldValue = this.jdbcActionStoreTablePrefix;
        this.jdbcActionStoreTablePrefix = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcActionStoreTablePrefix", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-communication-store-drop-table")
    public Boolean jdbcCommunicationStoreDropTable() {
        return this.jdbcCommunicationStoreDropTable;
    }

    public T jdbcCommunicationStoreDropTable(Boolean value) {
        Boolean oldValue = this.jdbcCommunicationStoreDropTable;
        this.jdbcCommunicationStoreDropTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcCommunicationStoreDropTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-communication-store-table-prefix")
    public String jdbcCommunicationStoreTablePrefix() {
        return this.jdbcCommunicationStoreTablePrefix;
    }

    public T jdbcCommunicationStoreTablePrefix(String value) {
        String oldValue = this.jdbcCommunicationStoreTablePrefix;
        this.jdbcCommunicationStoreTablePrefix = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcCommunicationStoreTablePrefix", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-state-store-drop-table")
    public Boolean jdbcStateStoreDropTable() {
        return this.jdbcStateStoreDropTable;
    }

    public T jdbcStateStoreDropTable(Boolean value) {
        Boolean oldValue = this.jdbcStateStoreDropTable;
        this.jdbcStateStoreDropTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcStateStoreDropTable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-state-store-table-prefix")
    public String jdbcStateStoreTablePrefix() {
        return this.jdbcStateStoreTablePrefix;
    }

    public T jdbcStateStoreTablePrefix(String value) {
        String oldValue = this.jdbcStateStoreTablePrefix;
        this.jdbcStateStoreTablePrefix = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcStateStoreTablePrefix", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jdbc-store-datasource")
    public String jdbcStoreDatasource() {
        return this.jdbcStoreDatasource;
    }

    public T jdbcStoreDatasource(String value) {
        String oldValue = this.jdbcStoreDatasource;
        this.jdbcStoreDatasource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jdbcStoreDatasource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="journal-store-enable-async-io")
    public Boolean journalStoreEnableAsyncIo() {
        return this.journalStoreEnableAsyncIo;
    }

    public T journalStoreEnableAsyncIo(Boolean value) {
        Boolean oldValue = this.journalStoreEnableAsyncIo;
        this.journalStoreEnableAsyncIo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("journalStoreEnableAsyncIo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jts")
    public Boolean jts() {
        return this.jts;
    }

    public T jts(Boolean value) {
        Boolean oldValue = this.jts;
        this.jts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="maximum-timeout")
    public Integer maximumTimeout() {
        return this.maximumTimeout;
    }

    public T maximumTimeout(Integer value) {
        Integer oldValue = this.maximumTimeout;
        this.maximumTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maximumTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="node-identifier")
    public String nodeIdentifier() {
        return this.nodeIdentifier;
    }

    public T nodeIdentifier(String value) {
        String oldValue = this.nodeIdentifier;
        this.nodeIdentifier = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nodeIdentifier", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-aborted-transactions")
    public Long numberOfAbortedTransactions() {
        return this.numberOfAbortedTransactions;
    }

    public T numberOfAbortedTransactions(Long value) {
        Long oldValue = this.numberOfAbortedTransactions;
        this.numberOfAbortedTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfAbortedTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-application-rollbacks")
    public Long numberOfApplicationRollbacks() {
        return this.numberOfApplicationRollbacks;
    }

    public T numberOfApplicationRollbacks(Long value) {
        Long oldValue = this.numberOfApplicationRollbacks;
        this.numberOfApplicationRollbacks = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfApplicationRollbacks", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-committed-transactions")
    public Long numberOfCommittedTransactions() {
        return this.numberOfCommittedTransactions;
    }

    public T numberOfCommittedTransactions(Long value) {
        Long oldValue = this.numberOfCommittedTransactions;
        this.numberOfCommittedTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfCommittedTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-heuristics")
    public Long numberOfHeuristics() {
        return this.numberOfHeuristics;
    }

    public T numberOfHeuristics(Long value) {
        Long oldValue = this.numberOfHeuristics;
        this.numberOfHeuristics = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfHeuristics", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-inflight-transactions")
    public Long numberOfInflightTransactions() {
        return this.numberOfInflightTransactions;
    }

    public T numberOfInflightTransactions(Long value) {
        Long oldValue = this.numberOfInflightTransactions;
        this.numberOfInflightTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfInflightTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-nested-transactions")
    public Long numberOfNestedTransactions() {
        return this.numberOfNestedTransactions;
    }

    public T numberOfNestedTransactions(Long value) {
        Long oldValue = this.numberOfNestedTransactions;
        this.numberOfNestedTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfNestedTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-resource-rollbacks")
    public Long numberOfResourceRollbacks() {
        return this.numberOfResourceRollbacks;
    }

    public T numberOfResourceRollbacks(Long value) {
        Long oldValue = this.numberOfResourceRollbacks;
        this.numberOfResourceRollbacks = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfResourceRollbacks", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-system-rollbacks")
    public Long numberOfSystemRollbacks() {
        return this.numberOfSystemRollbacks;
    }

    public T numberOfSystemRollbacks(Long value) {
        Long oldValue = this.numberOfSystemRollbacks;
        this.numberOfSystemRollbacks = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfSystemRollbacks", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-timed-out-transactions")
    public Long numberOfTimedOutTransactions() {
        return this.numberOfTimedOutTransactions;
    }

    public T numberOfTimedOutTransactions(Long value) {
        Long oldValue = this.numberOfTimedOutTransactions;
        this.numberOfTimedOutTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfTimedOutTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-transactions")
    public Long numberOfTransactions() {
        return this.numberOfTransactions;
    }

    public T numberOfTransactions(Long value) {
        Long oldValue = this.numberOfTransactions;
        this.numberOfTransactions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfTransactions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="object-store-path")
    public String objectStorePath() {
        return this.objectStorePath;
    }

    public T objectStorePath(String value) {
        String oldValue = this.objectStorePath;
        this.objectStorePath = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("objectStorePath", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="object-store-relative-to")
    public String objectStoreRelativeTo() {
        return this.objectStoreRelativeTo;
    }

    public T objectStoreRelativeTo(String value) {
        String oldValue = this.objectStoreRelativeTo;
        this.objectStoreRelativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("objectStoreRelativeTo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="process-id-socket-binding")
    public String processIdSocketBinding() {
        return this.processIdSocketBinding;
    }

    public T processIdSocketBinding(String value) {
        String oldValue = this.processIdSocketBinding;
        this.processIdSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("processIdSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="process-id-socket-max-ports")
    public Integer processIdSocketMaxPorts() {
        return this.processIdSocketMaxPorts;
    }

    public T processIdSocketMaxPorts(Integer value) {
        Integer oldValue = this.processIdSocketMaxPorts;
        this.processIdSocketMaxPorts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("processIdSocketMaxPorts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="process-id-uuid")
    public Boolean processIdUuid() {
        return this.processIdUuid;
    }

    public T processIdUuid(Boolean value) {
        Boolean oldValue = this.processIdUuid;
        this.processIdUuid = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("processIdUuid", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-listener")
    public Boolean recoveryListener() {
        return this.recoveryListener;
    }

    public T recoveryListener(Boolean value) {
        Boolean oldValue = this.recoveryListener;
        this.recoveryListener = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryListener", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="status-socket-binding")
    public String statusSocketBinding() {
        return this.statusSocketBinding;
    }

    public T statusSocketBinding(String value) {
        String oldValue = this.statusSocketBinding;
        this.statusSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statusSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="use-hornetq-store")
    public Boolean useHornetqStore() {
        return this.useHornetqStore;
    }

    @Deprecated
    public T useHornetqStore(Boolean value) {
        Boolean oldValue = this.useHornetqStore;
        this.useHornetqStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useHornetqStore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-jdbc-store")
    public Boolean useJdbcStore() {
        return this.useJdbcStore;
    }

    public T useJdbcStore(Boolean value) {
        Boolean oldValue = this.useJdbcStore;
        this.useJdbcStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useJdbcStore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-journal-store")
    public Boolean useJournalStore() {
        return this.useJournalStore;
    }

    public T useJournalStore(Boolean value) {
        Boolean oldValue = this.useJournalStore;
        this.useJournalStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useJournalStore", oldValue, value);
        }
        return (T)this;
    }

    public static class TransactionsResources {
        @ResourceDocumentation(value="a CMR resource (i.e. a local resource that can reliably participate in an XA transaction)")
        @SubresourceInfo(value="commitMarkableResource")
        private List<CommitMarkableResource> commitMarkableResources = new ArrayList<CommitMarkableResource>();
        @SingletonResource
        @ResourceDocumentation(value="Representation of the transaction logging storage mechanism.")
        private LogStore logStore;

        @Subresource
        public List<CommitMarkableResource> commitMarkableResources() {
            return this.commitMarkableResources;
        }

        public CommitMarkableResource commitMarkableResource(String key) {
            return this.commitMarkableResources.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public LogStore logStore() {
            return this.logStore;
        }
    }
}

