/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.deployment.scanner;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=deployment-scanner/scanner=*")
@ResourceType(value="scanner")
public class Scanner<T extends Scanner<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Allows the automatic deployment of exploded content without requiring a .dodeploy marker file. Recommended for only basic development scenarios to prevent exploded application deployment from occurring during changes by the developer or operating system.")
    private Boolean autoDeployExploded;
    @AttributeDocumentation(value="Allows automatic deployment of XML content without requiring a .dodeploy marker file.")
    private Boolean autoDeployXml;
    @AttributeDocumentation(value="Allows automatic deployment of zipped content without requiring a .dodeploy marker file.")
    private Boolean autoDeployZipped;
    @AttributeDocumentation(value="The time value in seconds for the deployment scanner to allow a deployment attempt before being cancelled.")
    private Long deploymentTimeout;
    @AttributeDocumentation(value="The actual filesystem path to be scanned. Treated as an absolute path, unless the 'relative-to' attribute is specified, in which case the value is treated as relative to that path.")
    private String path;
    @AttributeDocumentation(value="Reference to a filesystem path defined in the \"paths\" section of the server configuration.")
    private String relativeTo;
    @AttributeDocumentation(value="Flag indicating whether a runtime failure of a deployment causes a rollback of the deployment as well as all other (maybe unrelated) deployments as part of the scan operation.")
    private Boolean runtimeFailureCausesRollback;
    @AttributeDocumentation(value="Flag indicating if all scanning (including initial scanning at startup) is enabled.")
    private Boolean scanEnabled;
    @AttributeDocumentation(value="Periodic interval, in milliseconds, at which the repository should be scanned for changes. A value of less than 1 indicates the repository should only be scanned at initial startup.")
    private Integer scanInterval;

    public Scanner(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="auto-deploy-exploded")
    public Boolean autoDeployExploded() {
        return this.autoDeployExploded;
    }

    public T autoDeployExploded(Boolean value) {
        Boolean oldValue = this.autoDeployExploded;
        this.autoDeployExploded = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("autoDeployExploded", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auto-deploy-xml")
    public Boolean autoDeployXml() {
        return this.autoDeployXml;
    }

    public T autoDeployXml(Boolean value) {
        Boolean oldValue = this.autoDeployXml;
        this.autoDeployXml = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("autoDeployXml", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auto-deploy-zipped")
    public Boolean autoDeployZipped() {
        return this.autoDeployZipped;
    }

    public T autoDeployZipped(Boolean value) {
        Boolean oldValue = this.autoDeployZipped;
        this.autoDeployZipped = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("autoDeployZipped", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="deployment-timeout")
    public Long deploymentTimeout() {
        return this.deploymentTimeout;
    }

    public T deploymentTimeout(Long value) {
        Long oldValue = this.deploymentTimeout;
        this.deploymentTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deploymentTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="path")
    public String path() {
        return this.path;
    }

    public T path(String value) {
        String oldValue = this.path;
        this.path = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("path", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="relative-to")
    public String relativeTo() {
        return this.relativeTo;
    }

    public T relativeTo(String value) {
        String oldValue = this.relativeTo;
        this.relativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("relativeTo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="runtime-failure-causes-rollback")
    public Boolean runtimeFailureCausesRollback() {
        return this.runtimeFailureCausesRollback;
    }

    public T runtimeFailureCausesRollback(Boolean value) {
        Boolean oldValue = this.runtimeFailureCausesRollback;
        this.runtimeFailureCausesRollback = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("runtimeFailureCausesRollback", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scan-enabled")
    public Boolean scanEnabled() {
        return this.scanEnabled;
    }

    public T scanEnabled(Boolean value) {
        Boolean oldValue = this.scanEnabled;
        this.scanEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scanEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scan-interval")
    public Integer scanInterval() {
        return this.scanInterval;
    }

    public T scanInterval(Integer value) {
        Integer oldValue = this.scanInterval;
        this.scanInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scanInterval", oldValue, value);
        }
        return (T)this;
    }
}

