/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.discovery;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=discovery/aggregate-provider=*")
@ResourceType(value="aggregate-provider")
public class AggregateProvider<T extends AggregateProvider<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The list of providers that are aggregated by this provider")
    private List<String> providers;

    public AggregateProvider(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="providers")
    public List<String> providers() {
        return this.providers;
    }

    public T providers(List<String> value) {
        List<String> oldValue = this.providers;
        this.providers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providers", oldValue, value);
        }
        return (T)this;
    }

    public T provider(String value) {
        if (this.providers == null) {
            this.providers = new ArrayList<String>();
        }
        this.providers.add(value);
        return (T)this;
    }

    public T providers(String ... args) {
        this.providers(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

