/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.discovery;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=discovery/static-provider=*")
@ResourceType(value="static-provider")
public class StaticProvider<T extends StaticProvider<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The list of services that are configured with this provider")
    private List<Map> services;

    public StaticProvider(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="services")
    public List<Map> services() {
        return this.services;
    }

    public T services(List<Map> value) {
        List<Map> oldValue = this.services;
        this.services = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("services", oldValue, value);
        }
        return (T)this;
    }

    public T service(Map value) {
        if (this.services == null) {
            this.services = new ArrayList<Map>();
        }
        this.services.add(value);
        return (T)this;
    }

    public T services(Map ... args) {
        this.services(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

