/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ejb3;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=ejb3/thread-pool=*")
@ResourceType(value="thread-pool")
public class ThreadPool<T extends ThreadPool<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The approximate number of threads that are actively executing tasks.")
    private Integer activeCount;
    @AttributeDocumentation(value="The approximate total number of tasks that have completed execution.")
    private Integer completedTaskCount;
    @AttributeDocumentation(value="The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.")
    private Integer coreThreads;
    @AttributeDocumentation(value="The current number of threads in the pool.")
    private Integer currentThreadCount;
    @AttributeDocumentation(value="Used to specify the amount of time that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.")
    private Map keepaliveTime;
    @AttributeDocumentation(value="The largest number of threads that have ever simultaneously been in the pool.")
    private Integer largestThreadCount;
    @AttributeDocumentation(value="The maximum thread pool size.")
    private Integer maxThreads;
    @AttributeDocumentation(value="The name of the thread pool.")
    private String name;
    @AttributeDocumentation(value="The queue size.")
    private Integer queueSize;
    @AttributeDocumentation(value="The number of tasks that have been rejected.")
    private Integer rejectedCount;
    @AttributeDocumentation(value="The approximate total number of tasks that have ever been scheduled for execution.")
    private Integer taskCount;
    @AttributeDocumentation(value="Specifies the name of a specific thread factory to use to create worker threads. If not defined an appropriate default thread factory will be used.")
    private String threadFactory;

    public ThreadPool(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="active-count")
    public Integer activeCount() {
        return this.activeCount;
    }

    public T activeCount(Integer value) {
        Integer oldValue = this.activeCount;
        this.activeCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("activeCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="completed-task-count")
    public Integer completedTaskCount() {
        return this.completedTaskCount;
    }

    public T completedTaskCount(Integer value) {
        Integer oldValue = this.completedTaskCount;
        this.completedTaskCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("completedTaskCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="core-threads")
    public Integer coreThreads() {
        return this.coreThreads;
    }

    public T coreThreads(Integer value) {
        Integer oldValue = this.coreThreads;
        this.coreThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("coreThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="current-thread-count")
    public Integer currentThreadCount() {
        return this.currentThreadCount;
    }

    public T currentThreadCount(Integer value) {
        Integer oldValue = this.currentThreadCount;
        this.currentThreadCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("currentThreadCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keepalive-time")
    public Map keepaliveTime() {
        return this.keepaliveTime;
    }

    public T keepaliveTime(Map value) {
        Map oldValue = this.keepaliveTime;
        this.keepaliveTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keepaliveTime", oldValue, value);
        }
        return (T)this;
    }

    public T keepaliveTime(String key, Object value) {
        if (this.keepaliveTime == null) {
            this.keepaliveTime = new HashMap();
        }
        this.keepaliveTime.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="largest-thread-count")
    public Integer largestThreadCount() {
        return this.largestThreadCount;
    }

    public T largestThreadCount(Integer value) {
        Integer oldValue = this.largestThreadCount;
        this.largestThreadCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("largestThreadCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-threads")
    public Integer maxThreads() {
        return this.maxThreads;
    }

    public T maxThreads(Integer value) {
        Integer oldValue = this.maxThreads;
        this.maxThreads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxThreads", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="name")
    public String name() {
        return this.name;
    }

    public T name(String value) {
        String oldValue = this.name;
        this.name = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("name", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="queue-size")
    public Integer queueSize() {
        return this.queueSize;
    }

    public T queueSize(Integer value) {
        Integer oldValue = this.queueSize;
        this.queueSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queueSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="rejected-count")
    public Integer rejectedCount() {
        return this.rejectedCount;
    }

    public T rejectedCount(Integer value) {
        Integer oldValue = this.rejectedCount;
        this.rejectedCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("rejectedCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="task-count")
    public Integer taskCount() {
        return this.taskCount;
    }

    public T taskCount(Integer value) {
        Integer oldValue = this.taskCount;
        this.taskCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("taskCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-factory")
    public String threadFactory() {
        return this.threadFactory;
    }

    public T threadFactory(String value) {
        String oldValue = this.threadFactory;
        this.threadFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadFactory", oldValue, value);
        }
        return (T)this;
    }
}

