/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/aggregate-realm=*")
@ResourceType(value="aggregate-realm")
public class AggregateRealm<T extends AggregateRealm<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Reference to the security realm to use for authentication steps (obtaining or validating credentials).")
    private String authenticationRealm;
    @AttributeDocumentation(value="Reference to the security realm to use for loading the identity for authorization steps (loading of the identity).")
    private String authorizationRealm;
    @AttributeDocumentation(value="Reference to one or more security realms to use for loading the identity for authorization steps and aggregating the attributes (loading of the identity).")
    private List<String> authorizationRealms;
    @AttributeDocumentation(value="Reference to a principal transformer to apply between loading the identity for authentication and loading the identity for authorization")
    private String principalTransformer;

    public AggregateRealm(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="authentication-realm")
    public String authenticationRealm() {
        return this.authenticationRealm;
    }

    public T authenticationRealm(String value) {
        String oldValue = this.authenticationRealm;
        this.authenticationRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authorization-realm")
    public String authorizationRealm() {
        return this.authorizationRealm;
    }

    public T authorizationRealm(String value) {
        String oldValue = this.authorizationRealm;
        this.authorizationRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authorizationRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authorization-realms")
    public List<String> authorizationRealms() {
        return this.authorizationRealms;
    }

    public T authorizationRealms(List<String> value) {
        List<String> oldValue = this.authorizationRealms;
        this.authorizationRealms = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authorizationRealms", oldValue, value);
        }
        return (T)this;
    }

    public T authorizationRealmAppend(String value) {
        if (this.authorizationRealms == null) {
            this.authorizationRealms = new ArrayList<String>();
        }
        this.authorizationRealms.add(value);
        return (T)this;
    }

    public T authorizationRealms(String ... args) {
        this.authorizationRealms(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="principal-transformer")
    public String principalTransformer() {
        return this.principalTransformer;
    }

    public T principalTransformer(String value) {
        String oldValue = this.principalTransformer;
        this.principalTransformer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("principalTransformer", oldValue, value);
        }
        return (T)this;
    }
}

