/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/certificate-authority-account=*")
@ResourceType(value="certificate-authority-account")
public class CertificateAuthorityAccount<T extends CertificateAuthorityAccount<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The alias of certificate authority account key in the keystore. If the alias does not already exist in the keystore, a certificate authority account key will be automatically generated and stored as a PrivateKeyEntry under the alias.")
    private String alias;
    @AttributeDocumentation(value="The name of the certificate authority to use.")
    private String certificateAuthority;
    @AttributeDocumentation(value="A list of URLs that the certificate authority can contact about any issues related to this account.")
    private List<String> contactUrls;
    @AttributeDocumentation(value="Credential to be used when accessing the certificate authority account key.")
    private Map credentialReference;
    @AttributeDocumentation(value="The keystore that contains the certificate authority account key.")
    private String keyStore;

    public CertificateAuthorityAccount(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="alias")
    public String alias() {
        return this.alias;
    }

    public T alias(String value) {
        String oldValue = this.alias;
        this.alias = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("alias", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="certificate-authority")
    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    public T certificateAuthority(String value) {
        String oldValue = this.certificateAuthority;
        this.certificateAuthority = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("certificateAuthority", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="contact-urls")
    public List<String> contactUrls() {
        return this.contactUrls;
    }

    public T contactUrls(List<String> value) {
        List<String> oldValue = this.contactUrls;
        this.contactUrls = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("contactUrls", oldValue, value);
        }
        return (T)this;
    }

    public T contactUrl(String value) {
        if (this.contactUrls == null) {
            this.contactUrls = new ArrayList<String>();
        }
        this.contactUrls.add(value);
        return (T)this;
    }

    public T contactUrls(String ... args) {
        this.contactUrls(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="credential-reference")
    public Map credentialReference() {
        return this.credentialReference;
    }

    public T credentialReference(Map value) {
        Map oldValue = this.credentialReference;
        this.credentialReference = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("credentialReference", oldValue, value);
        }
        return (T)this;
    }

    public T credentialReference(String key, Object value) {
        if (this.credentialReference == null) {
            this.credentialReference = new HashMap();
        }
        this.credentialReference.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-store")
    public String keyStore() {
        return this.keyStore;
    }

    public T keyStore(String value) {
        String oldValue = this.keyStore;
        this.keyStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyStore", oldValue, value);
        }
        return (T)this;
    }
}

