/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.elytron.State;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/key-store=*")
@ResourceType(value="key-store")
public class KeyStore<T extends KeyStore<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="A filter to apply to the aliases returned from the KeyStore, can either be a comma separated list of aliases to return or one of the following formats ALL:-alias1:-alias2, NONE:+alias1:+alias2")
    private String aliasFilter;
    @AttributeDocumentation(value="The reference to credential stored in CredentialStore under defined alias or clear text password.")
    private Map credentialReference;
    @AttributeDocumentation(value="Information about the provider that was used for this KeyStore.")
    private Map loadedProvider;
    @AttributeDocumentation(value="Indicates if the in-memory representation of the KeyStore has been changed since it was last loaded or stored.  Note: For some providers updates may be immediate without further load or store calls.")
    private Boolean modified;
    @AttributeDocumentation(value="The path to the KeyStore file.")
    private String path;
    @AttributeDocumentation(value="The name of the provider to use to load the KeyStore, disables searching for the first Provider that can create a KeyStore of the specified type.")
    private String providerName;
    @AttributeDocumentation(value="A reference to the providers that should be used to obtain the list of Provider instances to search, if not specified the global list of providers will be used instead.")
    private String providers;
    @AttributeDocumentation(value="The base path this store is relative to.")
    private String relativeTo;
    @AttributeDocumentation(value="Is the file required to exist at the time the KeyStore service starts?")
    private Boolean required;
    @AttributeDocumentation(value="The number of entries in the KeyStore.")
    private Integer size;
    @AttributeDocumentation(value="The state of the underlying service that represents this KeyStore at runtime, if it is anything other than UP runtime operations will not be available.")
    private State state;
    @AttributeDocumentation(value="The time this KeyStore was last loaded or saved. Note: Some providers may continue to apply updates after the KeyStore was loaded within the application server.")
    private String attributeSynchronized;
    @AttributeDocumentation(value="The type of the KeyStore, used when creating the new KeyStore instance.")
    private String type;

    public KeyStore(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="alias-filter")
    public String aliasFilter() {
        return this.aliasFilter;
    }

    public T aliasFilter(String value) {
        String oldValue = this.aliasFilter;
        this.aliasFilter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("aliasFilter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="credential-reference")
    public Map credentialReference() {
        return this.credentialReference;
    }

    public T credentialReference(Map value) {
        Map oldValue = this.credentialReference;
        this.credentialReference = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("credentialReference", oldValue, value);
        }
        return (T)this;
    }

    public T credentialReference(String key, Object value) {
        if (this.credentialReference == null) {
            this.credentialReference = new HashMap();
        }
        this.credentialReference.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="loaded-provider")
    public Map loadedProvider() {
        return this.loadedProvider;
    }

    public T loadedProvider(Map value) {
        Map oldValue = this.loadedProvider;
        this.loadedProvider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("loadedProvider", oldValue, value);
        }
        return (T)this;
    }

    public T loadedProvider(String key, Object value) {
        if (this.loadedProvider == null) {
            this.loadedProvider = new HashMap();
        }
        this.loadedProvider.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="modified")
    public Boolean modified() {
        return this.modified;
    }

    public T modified(Boolean value) {
        Boolean oldValue = this.modified;
        this.modified = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("modified", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="path")
    public String path() {
        return this.path;
    }

    public T path(String value) {
        String oldValue = this.path;
        this.path = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("path", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="provider-name")
    public String providerName() {
        return this.providerName;
    }

    public T providerName(String value) {
        String oldValue = this.providerName;
        this.providerName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providerName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="providers")
    public String providers() {
        return this.providers;
    }

    public T providers(String value) {
        String oldValue = this.providers;
        this.providers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="relative-to")
    public String relativeTo() {
        return this.relativeTo;
    }

    public T relativeTo(String value) {
        String oldValue = this.relativeTo;
        this.relativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("relativeTo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="required")
    public Boolean required() {
        return this.required;
    }

    public T required(Boolean value) {
        Boolean oldValue = this.required;
        this.required = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("required", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="size")
    public Integer size() {
        return this.size;
    }

    public T size(Integer value) {
        Integer oldValue = this.size;
        this.size = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("size", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="state")
    public State state() {
        return this.state;
    }

    public T state(State value) {
        State oldValue = this.state;
        this.state = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("state", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="synchronized")
    public String attributeSynchronized() {
        return this.attributeSynchronized;
    }

    public T attributeSynchronized(String value) {
        String oldValue = this.attributeSynchronized;
        this.attributeSynchronized = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeSynchronized", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public String type() {
        return this.type;
    }

    public T type(String value) {
        String oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", oldValue, value);
        }
        return (T)this;
    }
}

