/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/ldap-realm=*")
@ResourceType(value="ldap-realm")
public class LdapRealm<T extends LdapRealm<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Does this realm support blank password direct verification? Blank password attempt will be rejected otherwise.")
    private Boolean allowBlankPassword;
    @AttributeDocumentation(value="The configuration to connect to a LDAP server.")
    private String dirContext;
    @AttributeDocumentation(value="Does this realm support verification of credentials by directly connecting to LDAP as the account being authenticated?")
    private Boolean directVerification;
    @AttributeDocumentation(value="The configuration options that define how principals are mapped to their corresponding entries in the underlying LDAP server.")
    private Map identityMapping;

    public LdapRealm(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="allow-blank-password")
    public Boolean allowBlankPassword() {
        return this.allowBlankPassword;
    }

    public T allowBlankPassword(Boolean value) {
        Boolean oldValue = this.allowBlankPassword;
        this.allowBlankPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowBlankPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="dir-context")
    public String dirContext() {
        return this.dirContext;
    }

    public T dirContext(String value) {
        String oldValue = this.dirContext;
        this.dirContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dirContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="direct-verification")
    public Boolean directVerification() {
        return this.directVerification;
    }

    public T directVerification(Boolean value) {
        Boolean oldValue = this.directVerification;
        this.directVerification = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("directVerification", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="identity-mapping")
    public Map identityMapping() {
        return this.identityMapping;
    }

    public T identityMapping(Map value) {
        Map oldValue = this.identityMapping;
        this.identityMapping = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("identityMapping", oldValue, value);
        }
        return (T)this;
    }

    public T identityMapping(String key, Object value) {
        if (this.identityMapping == null) {
            this.identityMapping = new HashMap();
        }
        this.identityMapping.put(key, value);
        return (T)this;
    }
}

