/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/logical-role-mapper=*")
@ResourceType(value="logical-role-mapper")
public class LogicalRoleMapper<T extends LogicalRoleMapper<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Reference to a role mapper to be used on the left side of the operation.")
    private String left;
    @AttributeDocumentation(value="The logical operation to be performed on the role mapper mappings.")
    private LogicalOperation logicalOperation;
    @AttributeDocumentation(value="Reference to a role mapper to be used on the right side of the operation.")
    private String right;

    public LogicalRoleMapper(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="left")
    public String left() {
        return this.left;
    }

    public T left(String value) {
        String oldValue = this.left;
        this.left = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("left", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="logical-operation")
    public LogicalOperation logicalOperation() {
        return this.logicalOperation;
    }

    public T logicalOperation(LogicalOperation value) {
        LogicalOperation oldValue = this.logicalOperation;
        this.logicalOperation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("logicalOperation", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="right")
    public String right() {
        return this.right;
    }

    public T right(String value) {
        String oldValue = this.right;
        this.right = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("right", oldValue, value);
        }
        return (T)this;
    }

    public static enum LogicalOperation {
        AND("and"),
        MINUS("minus"),
        OR("or"),
        XOR("xor");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private LogicalOperation(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

