/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/mechanism-provider-filtering-sasl-server-factory=*")
@ResourceType(value="mechanism-provider-filtering-sasl-server-factory")
public class MechanismProviderFilteringSASLServerFactory<T extends MechanismProviderFilteringSASLServerFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The SASL mechanisms available from this factory after all filtering has been applied.")
    private List<String> availableMechanisms;
    @AttributeDocumentation(value="When set to 'true' no provider loaded mechanisms are enabled unless matched by one of the filters, setting to 'false' has the inverse effect.")
    private Boolean enabling;
    @AttributeDocumentation(value="The filters to apply when comparing the mechanisms from the providers, a filter matches when all of the specified values match the mechanism / provider pair.")
    private List<Map> filters;
    @AttributeDocumentation(value="Reference to a sasl server factory to be wrapped by this definition.")
    private String saslServerFactory;

    public MechanismProviderFilteringSASLServerFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="available-mechanisms")
    public List<String> availableMechanisms() {
        return this.availableMechanisms;
    }

    public T availableMechanisms(List<String> value) {
        List<String> oldValue = this.availableMechanisms;
        this.availableMechanisms = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("availableMechanisms", oldValue, value);
        }
        return (T)this;
    }

    public T availableMechanism(String value) {
        if (this.availableMechanisms == null) {
            this.availableMechanisms = new ArrayList<String>();
        }
        this.availableMechanisms.add(value);
        return (T)this;
    }

    public T availableMechanisms(String ... args) {
        this.availableMechanisms(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enabling")
    public Boolean enabling() {
        return this.enabling;
    }

    public T enabling(Boolean value) {
        Boolean oldValue = this.enabling;
        this.enabling = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabling", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filters")
    public List<Map> filters() {
        return this.filters;
    }

    public T filters(List<Map> value) {
        List<Map> oldValue = this.filters;
        this.filters = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filters", oldValue, value);
        }
        return (T)this;
    }

    public T filter(Map value) {
        if (this.filters == null) {
            this.filters = new ArrayList<Map>();
        }
        this.filters.add(value);
        return (T)this;
    }

    public T filters(Map ... args) {
        this.filters(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-server-factory")
    public String saslServerFactory() {
        return this.saslServerFactory;
    }

    public T saslServerFactory(String value) {
        String oldValue = this.saslServerFactory;
        this.saslServerFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("saslServerFactory", oldValue, value);
        }
        return (T)this;
    }
}

