/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/server-ssl-sni-context=*")
@ResourceType(value="server-ssl-sni-context")
public class ServerSslSniContext<T extends ServerSslSniContext<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The context to use if no SNI information is present, or if it does not match any mappings")
    private String defaultSslContext;
    @AttributeDocumentation(value="A mapping between a server name and an SSContext")
    private Map hostContextMap;

    public ServerSslSniContext(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="default-ssl-context")
    public String defaultSslContext() {
        return this.defaultSslContext;
    }

    public T defaultSslContext(String value) {
        String oldValue = this.defaultSslContext;
        this.defaultSslContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultSslContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="host-context-map")
    public Map hostContextMap() {
        return this.hostContextMap;
    }

    public T hostContextMap(Map value) {
        Map oldValue = this.hostContextMap;
        this.hostContextMap = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("hostContextMap", oldValue, value);
        }
        return (T)this;
    }

    public T hostContextMap(String key, Object value) {
        if (this.hostContextMap == null) {
            this.hostContextMap = new HashMap();
        }
        this.hostContextMap.put(key, value);
        return (T)this;
    }
}

