/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/trust-manager=*")
@ResourceType(value="trust-manager")
public class TrustManager<T extends TrustManager<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of the algorithm to use to create the underlying TrustManagerFactory.")
    private String algorithm;
    @AttributeDocumentation(value="A filter to apply to the aliases returned from the KeyStore, can either be a comma separated list of aliases to return or one of the following formats ALL:-alias1:-alias2, NONE:+alias1:+alias2")
    private String aliasFilter;
    @AttributeDocumentation(value="Enables certificate revocation list checks to a trust manager.")
    private Map certificateRevocationList;
    @AttributeDocumentation(value="Reference to the KeyStore to use to initialise the underlying TrustManagerFactory.")
    private String keyStore;
    @AttributeDocumentation(value="The maximum number of non-self-issued intermediate certificates that may exist in a certification path for OCSP and CRL checks. If neither OCSP and CRL is configured, this attribute has no effect.")
    private Integer maximumCertPath;
    @AttributeDocumentation(value="Enables online certificate status protocol checks to a trust manager.")
    private Map ocsp;
    @AttributeDocumentation(value="Whether only leaf certificate should be checked for revocation status.")
    private Boolean onlyLeafCert;
    @AttributeDocumentation(value="The name of the provider to use to create the underlying TrustManagerFactory.")
    private String providerName;
    @AttributeDocumentation(value="Reference to obtain the Provider[] to use when creating the underlying TrustManagerFactory.")
    private String providers;
    @AttributeDocumentation(value="Whether a certificate with unknown OCSP response should be accepted.")
    private Boolean softFail;

    public TrustManager(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="algorithm")
    public String algorithm() {
        return this.algorithm;
    }

    public T algorithm(String value) {
        String oldValue = this.algorithm;
        this.algorithm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("algorithm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="alias-filter")
    public String aliasFilter() {
        return this.aliasFilter;
    }

    public T aliasFilter(String value) {
        String oldValue = this.aliasFilter;
        this.aliasFilter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("aliasFilter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="certificate-revocation-list")
    public Map certificateRevocationList() {
        return this.certificateRevocationList;
    }

    public T certificateRevocationList(Map value) {
        Map oldValue = this.certificateRevocationList;
        this.certificateRevocationList = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("certificateRevocationList", oldValue, value);
        }
        return (T)this;
    }

    public T certificateRevocationList(String key, Object value) {
        if (this.certificateRevocationList == null) {
            this.certificateRevocationList = new HashMap();
        }
        this.certificateRevocationList.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-store")
    public String keyStore() {
        return this.keyStore;
    }

    public T keyStore(String value) {
        String oldValue = this.keyStore;
        this.keyStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyStore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="maximum-cert-path")
    public Integer maximumCertPath() {
        return this.maximumCertPath;
    }

    public T maximumCertPath(Integer value) {
        Integer oldValue = this.maximumCertPath;
        this.maximumCertPath = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maximumCertPath", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ocsp")
    public Map ocsp() {
        return this.ocsp;
    }

    public T ocsp(Map value) {
        Map oldValue = this.ocsp;
        this.ocsp = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ocsp", oldValue, value);
        }
        return (T)this;
    }

    public T ocsp(String key, Object value) {
        if (this.ocsp == null) {
            this.ocsp = new HashMap();
        }
        this.ocsp.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="only-leaf-cert")
    public Boolean onlyLeafCert() {
        return this.onlyLeafCert;
    }

    public T onlyLeafCert(Boolean value) {
        Boolean oldValue = this.onlyLeafCert;
        this.onlyLeafCert = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("onlyLeafCert", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="provider-name")
    public String providerName() {
        return this.providerName;
    }

    public T providerName(String value) {
        String oldValue = this.providerName;
        this.providerName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providerName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="providers")
    public String providers() {
        return this.providers;
    }

    public T providers(String value) {
        String oldValue = this.providers;
        this.providers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providers", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="soft-fail")
    public Boolean softFail() {
        return this.softFail;
    }

    public T softFail(Boolean value) {
        Boolean oldValue = this.softFail;
        this.softFail = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("softFail", oldValue, value);
        }
        return (T)this;
    }
}

