/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/x509-subject-alt-name-evidence-decoder=*")
@ResourceType(value="x509-subject-alt-name-evidence-decoder")
public class X509SubjectAltNameEvidenceDecoder<T extends X509SubjectAltNameEvidenceDecoder<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The subject alternative name type to decode from the given evidence. Allowed values: 'rfc822Name', 'dNSName', 'directoryName', 'uniformResourceIdentifier', 'iPAddress', 'registeredID'")
    private AltNameType altNameType;
    @AttributeDocumentation(value="The 0-based occurrence of the subject alternative name to map. This attribute is optional and only used when there is more than one subject alternative name of the given alt-name-type. The default value is 0.")
    private Integer segment;

    public X509SubjectAltNameEvidenceDecoder(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="alt-name-type")
    public AltNameType altNameType() {
        return this.altNameType;
    }

    public T altNameType(AltNameType value) {
        AltNameType oldValue = this.altNameType;
        this.altNameType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("altNameType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="segment")
    public Integer segment() {
        return this.segment;
    }

    public T segment(Integer value) {
        Integer oldValue = this.segment;
        this.segment = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("segment", oldValue, value);
        }
        return (T)this;
    }

    public static enum AltNameType {
        RFC822NAME("rfc822Name"),
        DNSNAME("dNSName"),
        DIRECTORYNAME("directoryName"),
        UNIFORMRESOURCEIDENTIFIER("uniformResourceIdentifier"),
        IPADDRESS("iPAddress"),
        REGISTEREDID("registeredID");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private AltNameType(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

