/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.infinispan.remote_cache_container.AsyncThreadPool;
import org.wildfly.swarm.config.infinispan.remote_cache_container.AsyncThreadPoolConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.AsyncThreadPoolSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.ConnectionPoolComponent;
import org.wildfly.swarm.config.infinispan.remote_cache_container.ConnectionPoolComponentConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.ConnectionPoolComponentSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.InvalidationNearCache;
import org.wildfly.swarm.config.infinispan.remote_cache_container.InvalidationNearCacheConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.InvalidationNearCacheSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.NoneNearCache;
import org.wildfly.swarm.config.infinispan.remote_cache_container.NoneNearCacheConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.NoneNearCacheSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCache;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCacheConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCacheSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteCluster;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteClusterConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.RemoteClusterSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.SecurityComponent;
import org.wildfly.swarm.config.infinispan.remote_cache_container.SecurityComponentConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.SecurityComponentSupplier;
import org.wildfly.swarm.config.infinispan.remote_cache_container.TransactionComponent;
import org.wildfly.swarm.config.infinispan.remote_cache_container.TransactionComponentConsumer;
import org.wildfly.swarm.config.infinispan.remote_cache_container.TransactionComponentSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=infinispan/remote-cache-container=*")
@ResourceType(value="remote-cache-container")
public class RemoteCacheContainer<T extends RemoteCacheContainer<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private RemoteCacheContainerResources subresources = new RemoteCacheContainerResources();
    @AttributeDocumentation(value="The number of active connections to the Infinispan server.")
    private Integer activeConnections;
    @AttributeDocumentation(value="Defines the maximum socket connect timeout before giving up connecting to the server.")
    private Integer connectionTimeout;
    @AttributeDocumentation(value="The total number of connections to the Infinispan server.")
    private Integer connections;
    @AttributeDocumentation(value="Required default remote server cluster.")
    private String defaultRemoteCluster;
    @AttributeDocumentation(value="The number of idle connections to the Infinispan server.")
    private Integer idleConnections;
    @AttributeDocumentation(value="This hint allows sizing of byte buffers when serializing and deserializing keys, to minimize array resizing.")
    private Integer keySizeEstimate;
    @AttributeDocumentation(value="Sets the maximum number of retries for each request. A valid value should be greater or equals than 0. Zero means no retry will made in case of a network failure.")
    private Integer maxRetries;
    @AttributeDocumentation(value="Defines the module whose class loader should be used when configuring remote cache container marshaller.")
    private String module;
    @AttributeDocumentation(value="This property defines the protocol version that this client should use.")
    private ProtocolVersion protocolVersion;
    @AttributeDocumentation(value="Enable or disable SO_TIMEOUT on socket connections to remote Hot Rod servers with the specified timeout, in milliseconds. A timeout of 0 is interpreted as an infinite timeout.")
    private Integer socketTimeout;
    @AttributeDocumentation(value="Enables statistics gathering for this remote cache.")
    private Boolean statisticsEnabled;
    @AttributeDocumentation(value="Configures TCP Keepalive on the TCP stack.")
    private Boolean tcpKeepAlive;
    @AttributeDocumentation(value="Enable or disable TCP_NODELAY on socket connections to remote Hot Rod servers.")
    private Boolean tcpNoDelay;
    @AttributeDocumentation(value="This hint allows sizing of byte buffers when serializing and deserializing values, to minimize array resizing.")
    private Integer valueSizeEstimate;

    public RemoteCacheContainer(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public RemoteCacheContainerResources subresources() {
        return this.subresources;
    }

    public T remoteCaches(List<RemoteCache> value) {
        this.subresources.remoteCaches = value;
        return (T)this;
    }

    public T remoteCache(RemoteCache value) {
        this.subresources.remoteCaches.add(value);
        return (T)this;
    }

    public T remoteCache(String childKey, RemoteCacheConsumer consumer) {
        RemoteCache child = new RemoteCache(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.remoteCache(child);
        return (T)this;
    }

    public T remoteCache(String childKey) {
        this.remoteCache(childKey, null);
        return (T)this;
    }

    public T remoteCache(RemoteCacheSupplier supplier) {
        this.remoteCache(supplier.get());
        return (T)this;
    }

    public T remoteClusters(List<RemoteCluster> value) {
        this.subresources.remoteClusters = value;
        return (T)this;
    }

    public T remoteCluster(RemoteCluster value) {
        this.subresources.remoteClusters.add(value);
        return (T)this;
    }

    public T remoteCluster(String childKey, RemoteClusterConsumer consumer) {
        RemoteCluster child = new RemoteCluster(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.remoteCluster(child);
        return (T)this;
    }

    public T remoteCluster(String childKey) {
        this.remoteCluster(childKey, null);
        return (T)this;
    }

    public T remoteCluster(RemoteClusterSupplier supplier) {
        this.remoteCluster(supplier.get());
        return (T)this;
    }

    public T securityComponent(SecurityComponent value) {
        this.subresources.securityComponent = value;
        return (T)this;
    }

    public T securityComponent(SecurityComponentConsumer consumer) {
        SecurityComponent child = new SecurityComponent();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.securityComponent = child;
        return (T)this;
    }

    public T securityComponent() {
        SecurityComponent child = new SecurityComponent();
        this.subresources.securityComponent = child;
        return (T)this;
    }

    public T securityComponent(SecurityComponentSupplier supplier) {
        this.subresources.securityComponent = supplier.get();
        return (T)this;
    }

    public T transactionComponent(TransactionComponent value) {
        this.subresources.transactionComponent = value;
        return (T)this;
    }

    public T transactionComponent(TransactionComponentConsumer consumer) {
        TransactionComponent child = new TransactionComponent();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.transactionComponent = child;
        return (T)this;
    }

    public T transactionComponent() {
        TransactionComponent child = new TransactionComponent();
        this.subresources.transactionComponent = child;
        return (T)this;
    }

    public T transactionComponent(TransactionComponentSupplier supplier) {
        this.subresources.transactionComponent = supplier.get();
        return (T)this;
    }

    public T asyncThreadPool(AsyncThreadPool value) {
        this.subresources.asyncThreadPool = value;
        return (T)this;
    }

    public T asyncThreadPool(AsyncThreadPoolConsumer consumer) {
        AsyncThreadPool child = new AsyncThreadPool();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.asyncThreadPool = child;
        return (T)this;
    }

    public T asyncThreadPool() {
        AsyncThreadPool child = new AsyncThreadPool();
        this.subresources.asyncThreadPool = child;
        return (T)this;
    }

    public T asyncThreadPool(AsyncThreadPoolSupplier supplier) {
        this.subresources.asyncThreadPool = supplier.get();
        return (T)this;
    }

    public T connectionPoolComponent(ConnectionPoolComponent value) {
        this.subresources.connectionPoolComponent = value;
        return (T)this;
    }

    public T connectionPoolComponent(ConnectionPoolComponentConsumer consumer) {
        ConnectionPoolComponent child = new ConnectionPoolComponent();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.connectionPoolComponent = child;
        return (T)this;
    }

    public T connectionPoolComponent() {
        ConnectionPoolComponent child = new ConnectionPoolComponent();
        this.subresources.connectionPoolComponent = child;
        return (T)this;
    }

    public T connectionPoolComponent(ConnectionPoolComponentSupplier supplier) {
        this.subresources.connectionPoolComponent = supplier.get();
        return (T)this;
    }

    public T noneNearCache(NoneNearCache value) {
        this.subresources.noneNearCache = value;
        return (T)this;
    }

    public T noneNearCache(NoneNearCacheConsumer consumer) {
        NoneNearCache child = new NoneNearCache();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.noneNearCache = child;
        return (T)this;
    }

    public T noneNearCache() {
        NoneNearCache child = new NoneNearCache();
        this.subresources.noneNearCache = child;
        return (T)this;
    }

    public T noneNearCache(NoneNearCacheSupplier supplier) {
        this.subresources.noneNearCache = supplier.get();
        return (T)this;
    }

    public T invalidationNearCache(InvalidationNearCache value) {
        this.subresources.invalidationNearCache = value;
        return (T)this;
    }

    public T invalidationNearCache(InvalidationNearCacheConsumer consumer) {
        InvalidationNearCache child = new InvalidationNearCache();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.invalidationNearCache = child;
        return (T)this;
    }

    public T invalidationNearCache() {
        InvalidationNearCache child = new InvalidationNearCache();
        this.subresources.invalidationNearCache = child;
        return (T)this;
    }

    public T invalidationNearCache(InvalidationNearCacheSupplier supplier) {
        this.subresources.invalidationNearCache = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="active-connections")
    public Integer activeConnections() {
        return this.activeConnections;
    }

    public T activeConnections(Integer value) {
        Integer oldValue = this.activeConnections;
        this.activeConnections = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("activeConnections", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-timeout")
    public Integer connectionTimeout() {
        return this.connectionTimeout;
    }

    public T connectionTimeout(Integer value) {
        Integer oldValue = this.connectionTimeout;
        this.connectionTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectionTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connections")
    public Integer connections() {
        return this.connections;
    }

    public T connections(Integer value) {
        Integer oldValue = this.connections;
        this.connections = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connections", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-remote-cluster")
    public String defaultRemoteCluster() {
        return this.defaultRemoteCluster;
    }

    public T defaultRemoteCluster(String value) {
        String oldValue = this.defaultRemoteCluster;
        this.defaultRemoteCluster = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultRemoteCluster", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="idle-connections")
    public Integer idleConnections() {
        return this.idleConnections;
    }

    public T idleConnections(Integer value) {
        Integer oldValue = this.idleConnections;
        this.idleConnections = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("idleConnections", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-size-estimate")
    public Integer keySizeEstimate() {
        return this.keySizeEstimate;
    }

    public T keySizeEstimate(Integer value) {
        Integer oldValue = this.keySizeEstimate;
        this.keySizeEstimate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keySizeEstimate", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-retries")
    public Integer maxRetries() {
        return this.maxRetries;
    }

    public T maxRetries(Integer value) {
        Integer oldValue = this.maxRetries;
        this.maxRetries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRetries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol-version")
    public ProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    public T protocolVersion(ProtocolVersion value) {
        ProtocolVersion oldValue = this.protocolVersion;
        this.protocolVersion = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocolVersion", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-timeout")
    public Integer socketTimeout() {
        return this.socketTimeout;
    }

    public T socketTimeout(Integer value) {
        Integer oldValue = this.socketTimeout;
        this.socketTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tcp-keep-alive")
    public Boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public T tcpKeepAlive(Boolean value) {
        Boolean oldValue = this.tcpKeepAlive;
        this.tcpKeepAlive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tcpKeepAlive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tcp-no-delay")
    public Boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public T tcpNoDelay(Boolean value) {
        Boolean oldValue = this.tcpNoDelay;
        this.tcpNoDelay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tcpNoDelay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="value-size-estimate")
    public Integer valueSizeEstimate() {
        return this.valueSizeEstimate;
    }

    public T valueSizeEstimate(Integer value) {
        Integer oldValue = this.valueSizeEstimate;
        this.valueSizeEstimate = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("valueSizeEstimate", oldValue, value);
        }
        return (T)this;
    }

    public static enum ProtocolVersion {
        ONE_0("1.0"),
        ONE_1("1.1"),
        ONE_2("1.2"),
        ONE_3("1.3"),
        TWO_0("2.0"),
        TWO_1("2.1"),
        TWO_2("2.2"),
        TWO_3("2.3"),
        TWO_4("2.4"),
        TWO_5("2.5"),
        TWO_6("2.6"),
        TWO_7("2.7"),
        TWO_8("2.8"),
        TWO_9("2.9");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private ProtocolVersion(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class RemoteCacheContainerResources {
        @ResourceDocumentation(value="The configuration of the infinispan subsystem.")
        @SubresourceInfo(value="remoteCache")
        private List<RemoteCache> remoteCaches = new ArrayList<RemoteCache>();
        @ResourceDocumentation(value="Configuration of a remote cluster.")
        @SubresourceInfo(value="remoteCluster")
        private List<RemoteCluster> remoteClusters = new ArrayList<RemoteCluster>();
        @SingletonResource
        @ResourceDocumentation(value="Security configuration.")
        private SecurityComponent securityComponent;
        @SingletonResource
        @ResourceDocumentation(value="The cache transaction configuration.")
        private TransactionComponent transactionComponent;
        @SingletonResource
        @ResourceDocumentation(value="Defines a thread pool used for asynchronous operations.")
        private AsyncThreadPool asyncThreadPool;
        @SingletonResource
        @ResourceDocumentation(value="Configuration of the connection pool.")
        private ConnectionPoolComponent connectionPoolComponent;
        @SingletonResource
        @ResourceDocumentation(value="Disables near cache.")
        private NoneNearCache noneNearCache;
        @SingletonResource
        @ResourceDocumentation(value="Configures using near cache in invalidated mode. When entries are updated or removed server-side, invalidation messages will be sent to clients to remove them from the near cache.")
        private InvalidationNearCache invalidationNearCache;

        @Subresource
        public List<RemoteCache> remoteCaches() {
            return this.remoteCaches;
        }

        public RemoteCache remoteCache(String key) {
            return this.remoteCaches.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<RemoteCluster> remoteClusters() {
            return this.remoteClusters;
        }

        public RemoteCluster remoteCluster(String key) {
            return this.remoteClusters.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public SecurityComponent securityComponent() {
            return this.securityComponent;
        }

        @Subresource
        public TransactionComponent transactionComponent() {
            return this.transactionComponent;
        }

        @Subresource
        public AsyncThreadPool asyncThreadPool() {
            return this.asyncThreadPool;
        }

        @Subresource
        public ConnectionPoolComponent connectionPoolComponent() {
            return this.connectionPoolComponent;
        }

        @Subresource
        public NoneNearCache noneNearCache() {
            return this.noneNearCache;
        }

        @Subresource
        public InvalidationNearCache invalidationNearCache() {
            return this.invalidationNearCache;
        }
    }
}

