/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.infinispan.Dialect;
import org.wildfly.swarm.config.infinispan.cache_container.BehindWrite;
import org.wildfly.swarm.config.infinispan.cache_container.BehindWriteConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.BehindWriteSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.BinaryTable;
import org.wildfly.swarm.config.infinispan.cache_container.BinaryTableConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.BinaryTableSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.Property;
import org.wildfly.swarm.config.infinispan.cache_container.PropertyConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.PropertySupplier;
import org.wildfly.swarm.config.infinispan.cache_container.ThroughWrite;
import org.wildfly.swarm.config.infinispan.cache_container.ThroughWriteConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.ThroughWriteSupplier;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Addresses(value={"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=binary-jdbc", "/subsystem=infinispan/cache-container=*/local-cache=*/store=binary-jdbc", "/subsystem=infinispan/cache-container=*/replicated-cache=*/store=binary-jdbc", "/subsystem=infinispan/cache-container=*/distributed-cache=*/store=binary-jdbc", "/subsystem=infinispan/cache-container=*/scattered-cache=*/store=binary-jdbc"})
@ResourceType(value="store")
@Implicit
public class BinaryJDBCStore<T extends BinaryJDBCStore<T>>
implements Keyed {
    private String key = "binary-jdbc";
    private PropertyChangeSupport pcs;
    private BinaryJDBCStoreResources subresources = new BinaryJDBCStoreResources();
    @AttributeDocumentation(value="Defines a table used to store cache entries whose keys cannot be expressed as strings.")
    private Map binaryKeyedTable;
    @AttributeDocumentation(value="The number of cache loader node loads.")
    private Long cacheLoaderLoads;
    @AttributeDocumentation(value="The number of cache loader node misses.")
    private Long cacheLoaderMisses;
    @AttributeDocumentation(value="References the data source used to connect to this store.")
    private String dataSource;
    @AttributeDocumentation(value="The jndi name of the data source used to connect to this store.")
    private String datasource;
    @AttributeDocumentation(value="The dialect of this datastore.")
    private Dialect dialect;
    @AttributeDocumentation(value="If true, fetch persistent state when joining a cluster. If multiple cache stores are chained, only one of them can have this property enabled.")
    private Boolean fetchState;
    @AttributeDocumentation(value="The maximum size of a batch to be inserted/deleted from the store. If the value is less than one, then no upper limit is placed on the number of operations in a batch.")
    private Integer maxBatchSize;
    @AttributeDocumentation(value="If true, data is only written to the cache store when it is evicted from memory, a phenomenon known as 'passivation'. Next time the data is requested, it will be 'activated' which means that data will be brought back to memory and removed from the persistent store. If false, the cache store contains a copy of the contents in memory, so writes to cache result in cache store writes. This essentially gives you a 'write-through' configuration.")
    private Boolean passivation;
    @AttributeDocumentation(value="If true, when the cache starts, data stored in the cache store will be pre-loaded into memory. This is particularly useful when data in the cache store will be needed immediately after startup and you want to avoid cache operations being delayed as a result of loading this data lazily. Can be used to provide a 'warm-cache' on startup, however there is a performance penalty as startup time is affected by this process.")
    private Boolean preload;
    @AttributeDocumentation(value="A list of cache store properties.")
    private Map properties;
    @AttributeDocumentation(value="If true, purges this cache store when it starts up.")
    private Boolean purge;
    @AttributeDocumentation(value="This setting should be set to true when multiple cache instances share the same cache store (e.g., multiple nodes in a cluster using a JDBC-based CacheStore pointing to the same, shared database.) Setting this to true avoids multiple cache instances writing the same modification multiple times. If enabled, only the node where the modification originated will write to the cache store. If disabled, each individual cache reacts to a potential remote update by storing the data to the cache store.")
    private Boolean shared;
    @AttributeDocumentation(value="If true, the singleton store cache store is enabled. SingletonStore is a delegating cache store used for situations when only one instance in a cluster should interact with the underlying store.")
    private Boolean singleton;

    public BinaryJDBCStore() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public BinaryJDBCStoreResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    public T throughWrite(ThroughWrite value) {
        this.subresources.throughWrite = value;
        return (T)this;
    }

    public T throughWrite(ThroughWriteConsumer consumer) {
        ThroughWrite child = new ThroughWrite();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.throughWrite = child;
        return (T)this;
    }

    public T throughWrite() {
        ThroughWrite child = new ThroughWrite();
        this.subresources.throughWrite = child;
        return (T)this;
    }

    public T throughWrite(ThroughWriteSupplier supplier) {
        this.subresources.throughWrite = supplier.get();
        return (T)this;
    }

    public T behindWrite(BehindWrite value) {
        this.subresources.behindWrite = value;
        return (T)this;
    }

    public T behindWrite(BehindWriteConsumer consumer) {
        BehindWrite child = new BehindWrite();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.behindWrite = child;
        return (T)this;
    }

    public T behindWrite() {
        BehindWrite child = new BehindWrite();
        this.subresources.behindWrite = child;
        return (T)this;
    }

    public T behindWrite(BehindWriteSupplier supplier) {
        this.subresources.behindWrite = supplier.get();
        return (T)this;
    }

    public T binaryTable(BinaryTable value) {
        this.subresources.binaryTable = value;
        return (T)this;
    }

    public T binaryTable(BinaryTableConsumer consumer) {
        BinaryTable child = new BinaryTable();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.binaryTable = child;
        return (T)this;
    }

    public T binaryTable() {
        BinaryTable child = new BinaryTable();
        this.subresources.binaryTable = child;
        return (T)this;
    }

    public T binaryTable(BinaryTableSupplier supplier) {
        this.subresources.binaryTable = supplier.get();
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="binary-keyed-table")
    public Map binaryKeyedTable() {
        return this.binaryKeyedTable;
    }

    @Deprecated
    public T binaryKeyedTable(Map value) {
        Map oldValue = this.binaryKeyedTable;
        this.binaryKeyedTable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("binaryKeyedTable", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T binaryKeyedTable(String key, Object value) {
        if (this.binaryKeyedTable == null) {
            this.binaryKeyedTable = new HashMap();
        }
        this.binaryKeyedTable.put(key, value);
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="cache-loader-loads")
    public Long cacheLoaderLoads() {
        return this.cacheLoaderLoads;
    }

    @Deprecated
    public T cacheLoaderLoads(Long value) {
        Long oldValue = this.cacheLoaderLoads;
        this.cacheLoaderLoads = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cacheLoaderLoads", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="cache-loader-misses")
    public Long cacheLoaderMisses() {
        return this.cacheLoaderMisses;
    }

    @Deprecated
    public T cacheLoaderMisses(Long value) {
        Long oldValue = this.cacheLoaderMisses;
        this.cacheLoaderMisses = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cacheLoaderMisses", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="data-source")
    public String dataSource() {
        return this.dataSource;
    }

    public T dataSource(String value) {
        String oldValue = this.dataSource;
        this.dataSource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dataSource", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="datasource")
    public String datasource() {
        return this.datasource;
    }

    @Deprecated
    public T datasource(String value) {
        String oldValue = this.datasource;
        this.datasource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("datasource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="dialect")
    public Dialect dialect() {
        return this.dialect;
    }

    public T dialect(Dialect value) {
        Dialect oldValue = this.dialect;
        this.dialect = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("dialect", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="fetch-state")
    public Boolean fetchState() {
        return this.fetchState;
    }

    public T fetchState(Boolean value) {
        Boolean oldValue = this.fetchState;
        this.fetchState = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("fetchState", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-batch-size")
    public Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    public T maxBatchSize(Integer value) {
        Integer oldValue = this.maxBatchSize;
        this.maxBatchSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxBatchSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="passivation")
    public Boolean passivation() {
        return this.passivation;
    }

    public T passivation(Boolean value) {
        Boolean oldValue = this.passivation;
        this.passivation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("passivation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="preload")
    public Boolean preload() {
        return this.preload;
    }

    public T preload(Boolean value) {
        Boolean oldValue = this.preload;
        this.preload = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("preload", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="purge")
    public Boolean purge() {
        return this.purge;
    }

    public T purge(Boolean value) {
        Boolean oldValue = this.purge;
        this.purge = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("purge", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="shared")
    public Boolean shared() {
        return this.shared;
    }

    public T shared(Boolean value) {
        Boolean oldValue = this.shared;
        this.shared = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("shared", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="singleton")
    public Boolean singleton() {
        return this.singleton;
    }

    @Deprecated
    public T singleton(Boolean value) {
        Boolean oldValue = this.singleton;
        this.singleton = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("singleton", oldValue, value);
        }
        return (T)this;
    }

    public static class BinaryJDBCStoreResources {
        @ResourceDocumentation(value="A cache store property with name and value.")
        @SubresourceInfo(value="property")
        private List<Property> properties = new ArrayList<Property>();
        @SingletonResource
        @ResourceDocumentation(value="Configures a cache store as write-through.")
        private ThroughWrite throughWrite;
        @SingletonResource
        @ResourceDocumentation(value="Configures a cache store as write-behind instead of write-through.")
        private BehindWrite behindWrite;
        @SingletonResource
        @ResourceDocumentation(value="Defines a table used to store cache entries whose keys cannot be expressed as strings.")
        private BinaryTable binaryTable;

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public ThroughWrite throughWrite() {
            return this.throughWrite;
        }

        @Subresource
        public BehindWrite behindWrite() {
            return this.behindWrite;
        }

        @Subresource
        public BinaryTable binaryTable() {
            return this.binaryTable;
        }
    }
}

