/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.infinispan.cache_container.cache.LockingComponent;
import org.wildfly.swarm.config.infinispan.cache_container.cache.LockingComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.cache.LockingComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PartitionHandlingComponent;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PartitionHandlingComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PartitionHandlingComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PersistenceComponent;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PersistenceComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.cache.PersistenceComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.cache.TransactionComponent;
import org.wildfly.swarm.config.infinispan.cache_container.cache.TransactionComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.cache.TransactionComponentSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=infinispan/cache-container=*/cache=*")
@ResourceType(value="cache")
public class Cache<T extends Cache<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private CacheResources subresources = new CacheResources();
    @AttributeDocumentation(value="The number of cache node activations (bringing a node into memory from a cache store).")
    private Long activations;
    @AttributeDocumentation(value="Average time (in ms) for cache reads. Includes hits and misses.")
    private Long averageReadTime;
    @AttributeDocumentation(value="Average time (in ms) for cache removes.")
    private Long averageRemoveTime;
    @AttributeDocumentation(value="The average time taken to replicate data around the cluster.")
    private Long averageReplicationTime;
    @AttributeDocumentation(value="Average time (in ms) for cache writes.")
    private Long averageWriteTime;
    @AttributeDocumentation(value="The number of cache eviction operations.")
    private Long evictions;
    @AttributeDocumentation(value="The hit/miss ratio for the cache (hits/hits+misses).")
    private Double hitRatio;
    @AttributeDocumentation(value="The number of cache attribute hits.")
    private Long hits;
    @AttributeDocumentation(value="The number of cache invalidations.")
    private Long invalidations;
    @AttributeDocumentation(value="The number of cache attribute misses.")
    private Long misses;
    @AttributeDocumentation(value="The number of entries in the cache including passivated entries.")
    private Integer numberOfEntries;
    @AttributeDocumentation(value="The number of entries in the cache excluding passivated entries.")
    private Integer numberOfEntriesInMemory;
    @AttributeDocumentation(value="The number of cache node passivations (passivating a node from memory to a cache store).")
    private Long passivations;
    @AttributeDocumentation(value="The read/write ratio of the cache ((hits+misses)/stores).")
    private Double readWriteRatio;
    @AttributeDocumentation(value="The number of cache attribute remove hits.")
    private Long removeHits;
    @AttributeDocumentation(value="The number of cache attribute remove misses.")
    private Long removeMisses;
    @AttributeDocumentation(value="The number of times data was replicated around the cluster.")
    private Long replicationCount;
    @AttributeDocumentation(value="The number of data replication failures.")
    private Long replicationFailures;
    @AttributeDocumentation(value="The data replication success ratio (successes/successes+failures).")
    private Double successRatio;
    @AttributeDocumentation(value="Time (in secs) since cache statistics were reset.")
    private Long timeSinceReset;
    @AttributeDocumentation(value="Time (in secs) since cache was started.")
    private Long timeSinceStart;
    @AttributeDocumentation(value="The number of cache attribute put operations.")
    private Long writes;

    public Cache(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public CacheResources subresources() {
        return this.subresources;
    }

    public T persistenceComponent(PersistenceComponent value) {
        this.subresources.persistenceComponent = value;
        return (T)this;
    }

    public T persistenceComponent(PersistenceComponentConsumer consumer) {
        PersistenceComponent child = new PersistenceComponent();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.persistenceComponent = child;
        return (T)this;
    }

    public T persistenceComponent() {
        PersistenceComponent child = new PersistenceComponent();
        this.subresources.persistenceComponent = child;
        return (T)this;
    }

    public T persistenceComponent(PersistenceComponentSupplier supplier) {
        this.subresources.persistenceComponent = supplier.get();
        return (T)this;
    }

    public T transactionComponent(TransactionComponent value) {
        this.subresources.transactionComponent = value;
        return (T)this;
    }

    public T transactionComponent(TransactionComponentConsumer consumer) {
        TransactionComponent child = new TransactionComponent();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.transactionComponent = child;
        return (T)this;
    }

    public T transactionComponent() {
        TransactionComponent child = new TransactionComponent();
        this.subresources.transactionComponent = child;
        return (T)this;
    }

    public T transactionComponent(TransactionComponentSupplier supplier) {
        this.subresources.transactionComponent = supplier.get();
        return (T)this;
    }

    public T partitionHandlingComponent(PartitionHandlingComponent value) {
        this.subresources.partitionHandlingComponent = value;
        return (T)this;
    }

    public T partitionHandlingComponent(PartitionHandlingComponentConsumer consumer) {
        PartitionHandlingComponent child = new PartitionHandlingComponent();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.partitionHandlingComponent = child;
        return (T)this;
    }

    public T partitionHandlingComponent() {
        PartitionHandlingComponent child = new PartitionHandlingComponent();
        this.subresources.partitionHandlingComponent = child;
        return (T)this;
    }

    public T partitionHandlingComponent(PartitionHandlingComponentSupplier supplier) {
        this.subresources.partitionHandlingComponent = supplier.get();
        return (T)this;
    }

    public T lockingComponent(LockingComponent value) {
        this.subresources.lockingComponent = value;
        return (T)this;
    }

    public T lockingComponent(LockingComponentConsumer consumer) {
        LockingComponent child = new LockingComponent();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.lockingComponent = child;
        return (T)this;
    }

    public T lockingComponent() {
        LockingComponent child = new LockingComponent();
        this.subresources.lockingComponent = child;
        return (T)this;
    }

    public T lockingComponent(LockingComponentSupplier supplier) {
        this.subresources.lockingComponent = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="activations")
    public Long activations() {
        return this.activations;
    }

    public T activations(Long value) {
        Long oldValue = this.activations;
        this.activations = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("activations", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="average-read-time")
    public Long averageReadTime() {
        return this.averageReadTime;
    }

    public T averageReadTime(Long value) {
        Long oldValue = this.averageReadTime;
        this.averageReadTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("averageReadTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="average-remove-time")
    public Long averageRemoveTime() {
        return this.averageRemoveTime;
    }

    public T averageRemoveTime(Long value) {
        Long oldValue = this.averageRemoveTime;
        this.averageRemoveTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("averageRemoveTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="average-replication-time")
    public Long averageReplicationTime() {
        return this.averageReplicationTime;
    }

    public T averageReplicationTime(Long value) {
        Long oldValue = this.averageReplicationTime;
        this.averageReplicationTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("averageReplicationTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="average-write-time")
    public Long averageWriteTime() {
        return this.averageWriteTime;
    }

    public T averageWriteTime(Long value) {
        Long oldValue = this.averageWriteTime;
        this.averageWriteTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("averageWriteTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="evictions")
    public Long evictions() {
        return this.evictions;
    }

    public T evictions(Long value) {
        Long oldValue = this.evictions;
        this.evictions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("evictions", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="hit-ratio")
    public Double hitRatio() {
        return this.hitRatio;
    }

    public T hitRatio(Double value) {
        Double oldValue = this.hitRatio;
        this.hitRatio = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("hitRatio", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="hits")
    public Long hits() {
        return this.hits;
    }

    public T hits(Long value) {
        Long oldValue = this.hits;
        this.hits = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("hits", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="invalidations")
    public Long invalidations() {
        return this.invalidations;
    }

    public T invalidations(Long value) {
        Long oldValue = this.invalidations;
        this.invalidations = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("invalidations", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="misses")
    public Long misses() {
        return this.misses;
    }

    public T misses(Long value) {
        Long oldValue = this.misses;
        this.misses = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("misses", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-entries")
    public Integer numberOfEntries() {
        return this.numberOfEntries;
    }

    public T numberOfEntries(Integer value) {
        Integer oldValue = this.numberOfEntries;
        this.numberOfEntries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfEntries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-entries-in-memory")
    public Integer numberOfEntriesInMemory() {
        return this.numberOfEntriesInMemory;
    }

    public T numberOfEntriesInMemory(Integer value) {
        Integer oldValue = this.numberOfEntriesInMemory;
        this.numberOfEntriesInMemory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfEntriesInMemory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="passivations")
    public Long passivations() {
        return this.passivations;
    }

    public T passivations(Long value) {
        Long oldValue = this.passivations;
        this.passivations = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("passivations", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="read-write-ratio")
    public Double readWriteRatio() {
        return this.readWriteRatio;
    }

    public T readWriteRatio(Double value) {
        Double oldValue = this.readWriteRatio;
        this.readWriteRatio = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("readWriteRatio", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="remove-hits")
    public Long removeHits() {
        return this.removeHits;
    }

    public T removeHits(Long value) {
        Long oldValue = this.removeHits;
        this.removeHits = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("removeHits", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="remove-misses")
    public Long removeMisses() {
        return this.removeMisses;
    }

    public T removeMisses(Long value) {
        Long oldValue = this.removeMisses;
        this.removeMisses = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("removeMisses", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="replication-count")
    public Long replicationCount() {
        return this.replicationCount;
    }

    public T replicationCount(Long value) {
        Long oldValue = this.replicationCount;
        this.replicationCount = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("replicationCount", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="replication-failures")
    public Long replicationFailures() {
        return this.replicationFailures;
    }

    public T replicationFailures(Long value) {
        Long oldValue = this.replicationFailures;
        this.replicationFailures = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("replicationFailures", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="success-ratio")
    public Double successRatio() {
        return this.successRatio;
    }

    public T successRatio(Double value) {
        Double oldValue = this.successRatio;
        this.successRatio = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("successRatio", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="time-since-reset")
    public Long timeSinceReset() {
        return this.timeSinceReset;
    }

    public T timeSinceReset(Long value) {
        Long oldValue = this.timeSinceReset;
        this.timeSinceReset = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeSinceReset", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="time-since-start")
    public Long timeSinceStart() {
        return this.timeSinceStart;
    }

    public T timeSinceStart(Long value) {
        Long oldValue = this.timeSinceStart;
        this.timeSinceStart = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeSinceStart", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="writes")
    public Long writes() {
        return this.writes;
    }

    public T writes(Long value) {
        Long oldValue = this.writes;
        this.writes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("writes", oldValue, value);
        }
        return (T)this;
    }

    public static class CacheResources {
        @SingletonResource
        @ResourceDocumentation(value="The configuration of the infinispan subsystem.")
        private PersistenceComponent persistenceComponent;
        @SingletonResource
        @ResourceDocumentation(value="The cache transaction configuration.")
        private TransactionComponent transactionComponent;
        @SingletonResource
        @ResourceDocumentation(value="The partition handling configuration for distributed and replicated caches.")
        private PartitionHandlingComponent partitionHandlingComponent;
        @SingletonResource
        @ResourceDocumentation(value="The locking configuration of the cache.")
        private LockingComponent lockingComponent;

        @Subresource
        public PersistenceComponent persistenceComponent() {
            return this.persistenceComponent;
        }

        @Subresource
        public TransactionComponent transactionComponent() {
            return this.transactionComponent;
        }

        @Subresource
        public PartitionHandlingComponent partitionHandlingComponent() {
            return this.partitionHandlingComponent;
        }

        @Subresource
        public LockingComponent lockingComponent() {
            return this.lockingComponent;
        }
    }
}

