/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=infinispan/cache-container=*/invalidation-cache=*/memory=object", "/subsystem=infinispan/cache-container=*/local-cache=*/memory=object", "/subsystem=infinispan/cache-container=*/replicated-cache=*/memory=object", "/subsystem=infinispan/cache-container=*/distributed-cache=*/memory=object", "/subsystem=infinispan/cache-container=*/scattered-cache=*/memory=object"})
@ResourceType(value="memory")
@Implicit
public class ObjectMemory<T extends ObjectMemory<T>>
implements Keyed {
    private String key = "object";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The number of cache eviction operations.")
    private Long evictions;
    @AttributeDocumentation(value="Maximum number of entries in a cache instance. If selected value is not a power of two the actual value will default to the least power of two larger than selected value. -1 means no limit.")
    private Long maxEntries;
    @AttributeDocumentation(value="Triggers eviction of the least recently used entries when the number of cache entries exceeds this threshold.")
    private Long size;
    @AttributeDocumentation(value="Sets the cache eviction strategy. Available options are 'UNORDERED', 'FIFO', 'LRU', 'LIRS' and 'NONE' (to disable eviction).")
    private String strategy;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @Deprecated
    @ModelNodeBinding(detypedName="evictions")
    public Long evictions() {
        return this.evictions;
    }

    @Deprecated
    public T evictions(Long value) {
        Long oldValue = this.evictions;
        this.evictions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("evictions", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="max-entries")
    public Long maxEntries() {
        return this.maxEntries;
    }

    @Deprecated
    public T maxEntries(Long value) {
        Long oldValue = this.maxEntries;
        this.maxEntries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxEntries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="size")
    public Long size() {
        return this.size;
    }

    public T size(Long value) {
        Long oldValue = this.size;
        this.size = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("size", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="strategy")
    public String strategy() {
        return this.strategy;
    }

    @Deprecated
    public T strategy(String value) {
        String oldValue = this.strategy;
        this.strategy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("strategy", oldValue, value);
        }
        return (T)this;
    }
}

