/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=state-transfer", "/subsystem=infinispan/cache-container=*/distributed-cache=*/component=state-transfer", "/subsystem=infinispan/cache-container=*/scattered-cache=*/component=state-transfer"})
@ResourceType(value="component")
@Implicit
public class StateTransferComponent<T extends StateTransferComponent<T>>
implements Keyed {
    private String key = "state-transfer";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The maximum number of cache entries in a batch of transferred state.")
    private Integer chunkSize;
    @AttributeDocumentation(value="If enabled, this will cause the cache to ask neighboring caches for state when it starts up, so the cache starts 'warm', although it will impact startup time.")
    private Boolean enabled;
    @AttributeDocumentation(value="The maximum amount of time (ms) to wait for state from neighboring caches, before throwing an exception and aborting startup. If timeout is 0, state transfer is performed asynchronously, and the cache will be immediately available.")
    private Long timeout;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="chunk-size")
    public Integer chunkSize() {
        return this.chunkSize;
    }

    public T chunkSize(Integer value) {
        Integer oldValue = this.chunkSize;
        this.chunkSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("chunkSize", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    @Deprecated
    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="timeout")
    public Long timeout() {
        return this.timeout;
    }

    public T timeout(Long value) {
        Long oldValue = this.timeout;
        this.timeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeout", oldValue, value);
        }
        return (T)this;
    }
}

