/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.cache_container.cache;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=infinispan/cache-container=*/cache=*/component=locking")
@ResourceType(value="component")
@Implicit
public class LockingComponent<T extends LockingComponent<T>>
implements Keyed {
    private String key = "locking";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The estimated number of concurrently updating threads which this cache can support.")
    private Integer currentConcurrencyLevel;
    @AttributeDocumentation(value="The number of locks available to this cache.")
    private Integer numberOfLocksAvailable;
    @AttributeDocumentation(value="The number of locks currently in use by this cache.")
    private Integer numberOfLocksHeld;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="current-concurrency-level")
    public Integer currentConcurrencyLevel() {
        return this.currentConcurrencyLevel;
    }

    public T currentConcurrencyLevel(Integer value) {
        Integer oldValue = this.currentConcurrencyLevel;
        this.currentConcurrencyLevel = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("currentConcurrencyLevel", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-locks-available")
    public Integer numberOfLocksAvailable() {
        return this.numberOfLocksAvailable;
    }

    public T numberOfLocksAvailable(Integer value) {
        Integer oldValue = this.numberOfLocksAvailable;
        this.numberOfLocksAvailable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfLocksAvailable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="number-of-locks-held")
    public Integer numberOfLocksHeld() {
        return this.numberOfLocksHeld;
    }

    public T numberOfLocksHeld(Integer value) {
        Integer oldValue = this.numberOfLocksHeld;
        this.numberOfLocksHeld = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("numberOfLocksHeld", oldValue, value);
        }
        return (T)this;
    }
}

