/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.remote_cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=infinispan/remote-cache-container=*/component=connection-pool")
@ResourceType(value="component")
@Implicit
public class ConnectionPoolComponent<T extends ConnectionPoolComponent<T>>
implements Keyed {
    private String key = "connection-pool";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="Specifies what happens when asking for a connection from a server's pool, and that pool is exhausted.")
    private ExhaustedAction exhaustedAction;
    @AttributeDocumentation(value="Controls the maximum number of connections per server that are allocated (checked out to client threads, or idle in the pool) at one time. When non-positive, there is no limit to the number of connections per server. When maxActive is reached, the connection pool for that server is said to be exhausted. Value -1 means no limit.")
    private Integer maxActive;
    @AttributeDocumentation(value="The amount of time in milliseconds to wait for a connection to become available when the exhausted action is ExhaustedAction.WAIT, after which a java.util.NoSuchElementException will be thrown. If a negative value is supplied, the pool will block indefinitely.")
    private Long maxWait;
    @AttributeDocumentation(value="Specifies the minimum amount of time that an connection may sit idle in the pool before it is eligible for eviction due to idle time. When non-positive, no connection will be dropped from the pool due to idle time alone. This setting has no effect unless timeBetweenEvictionRunsMillis > 0.")
    private Long minEvictableIdleTime;
    @AttributeDocumentation(value="Sets a target value for the minimum number of idle connections (per server) that should always be available. If this parameter is set to a positive number and timeBetweenEvictionRunsMillis > 0, each time the idle connection eviction thread runs, it will try to create enough idle instances so that there will be minIdle idle instances available for each server.")
    private Integer minIdle;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="exhausted-action")
    public ExhaustedAction exhaustedAction() {
        return this.exhaustedAction;
    }

    public T exhaustedAction(ExhaustedAction value) {
        ExhaustedAction oldValue = this.exhaustedAction;
        this.exhaustedAction = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exhaustedAction", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-active")
    public Integer maxActive() {
        return this.maxActive;
    }

    public T maxActive(Integer value) {
        Integer oldValue = this.maxActive;
        this.maxActive = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxActive", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-wait")
    public Long maxWait() {
        return this.maxWait;
    }

    public T maxWait(Long value) {
        Long oldValue = this.maxWait;
        this.maxWait = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxWait", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-evictable-idle-time")
    public Long minEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    public T minEvictableIdleTime(Long value) {
        Long oldValue = this.minEvictableIdleTime;
        this.minEvictableIdleTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minEvictableIdleTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-idle")
    public Integer minIdle() {
        return this.minIdle;
    }

    public T minIdle(Integer value) {
        Integer oldValue = this.minIdle;
        this.minIdle = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minIdle", oldValue, value);
        }
        return (T)this;
    }

    public static enum ExhaustedAction {
        EXCEPTION("EXCEPTION"),
        WAIT("WAIT"),
        CREATE_NEW("CREATE_NEW");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private ExhaustedAction(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

