/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.remote_cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=infinispan/remote-cache-container=*/remote-cache=*")
@ResourceType(value="remote-cache")
public class RemoteCache<T extends RemoteCache<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The average read time, in milliseconds, for this remote cache.")
    private Long averageReadTime;
    @AttributeDocumentation(value="The average remove time, in milliseconds, for this remote cache.")
    private Long averageRemoveTime;
    @AttributeDocumentation(value="The average write time, in milliseconds, to this remote cache.")
    private Long averageWriteTime;
    @AttributeDocumentation(value="The number of hits to this remote cache, excluding hits from the near-cache.")
    private Long hits;
    @AttributeDocumentation(value="The number of misses to this remote cache.")
    private Long misses;
    @AttributeDocumentation(value="The number of near-cache hits for this remote cache.")
    private Long nearCacheHits;
    @AttributeDocumentation(value="The number of near-cache invalidations for this remote cache.")
    private Long nearCacheInvalidations;
    @AttributeDocumentation(value="The number of near-cache misses for this remote cache.")
    private Long nearCacheMisses;
    @AttributeDocumentation(value="The number of entries in the near-cache for this remote cache.")
    private Long nearCacheSize;
    @AttributeDocumentation(value="The number of removes to this remote cache.")
    private Long removes;
    @AttributeDocumentation(value="The number of seconds since statistics were reset on this remote cache.")
    private Long timeSinceReset;
    @AttributeDocumentation(value="The number of writes to this remote cache.")
    private Long writes;

    public RemoteCache(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="average-read-time")
    public Long averageReadTime() {
        return this.averageReadTime;
    }

    public T averageReadTime(Long value) {
        Long oldValue = this.averageReadTime;
        this.averageReadTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("averageReadTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="average-remove-time")
    public Long averageRemoveTime() {
        return this.averageRemoveTime;
    }

    public T averageRemoveTime(Long value) {
        Long oldValue = this.averageRemoveTime;
        this.averageRemoveTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("averageRemoveTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="average-write-time")
    public Long averageWriteTime() {
        return this.averageWriteTime;
    }

    public T averageWriteTime(Long value) {
        Long oldValue = this.averageWriteTime;
        this.averageWriteTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("averageWriteTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="hits")
    public Long hits() {
        return this.hits;
    }

    public T hits(Long value) {
        Long oldValue = this.hits;
        this.hits = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("hits", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="misses")
    public Long misses() {
        return this.misses;
    }

    public T misses(Long value) {
        Long oldValue = this.misses;
        this.misses = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("misses", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="near-cache-hits")
    public Long nearCacheHits() {
        return this.nearCacheHits;
    }

    public T nearCacheHits(Long value) {
        Long oldValue = this.nearCacheHits;
        this.nearCacheHits = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nearCacheHits", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="near-cache-invalidations")
    public Long nearCacheInvalidations() {
        return this.nearCacheInvalidations;
    }

    public T nearCacheInvalidations(Long value) {
        Long oldValue = this.nearCacheInvalidations;
        this.nearCacheInvalidations = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nearCacheInvalidations", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="near-cache-misses")
    public Long nearCacheMisses() {
        return this.nearCacheMisses;
    }

    public T nearCacheMisses(Long value) {
        Long oldValue = this.nearCacheMisses;
        this.nearCacheMisses = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nearCacheMisses", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="near-cache-size")
    public Long nearCacheSize() {
        return this.nearCacheSize;
    }

    public T nearCacheSize(Long value) {
        Long oldValue = this.nearCacheSize;
        this.nearCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nearCacheSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="removes")
    public Long removes() {
        return this.removes;
    }

    public T removes(Long value) {
        Long oldValue = this.removes;
        this.removes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("removes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="time-since-reset")
    public Long timeSinceReset() {
        return this.timeSinceReset;
    }

    public T timeSinceReset(Long value) {
        Long oldValue = this.timeSinceReset;
        this.timeSinceReset = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeSinceReset", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="writes")
    public Long writes() {
        return this.writes;
    }

    public T writes(Long value) {
        Long oldValue = this.writes;
        this.writes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("writes", oldValue, value);
        }
        return (T)this;
    }
}

