/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.remote_cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=infinispan/remote-cache-container=*/remote-cluster=*")
@ResourceType(value="remote-cluster")
public class RemoteCluster<T extends RemoteCluster<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="List of outbound-socket-bindings of Hot Rod servers to connect to.")
    private List<String> socketBindings;

    public RemoteCluster(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="socket-bindings")
    public List<String> socketBindings() {
        return this.socketBindings;
    }

    public T socketBindings(List<String> value) {
        List<String> oldValue = this.socketBindings;
        this.socketBindings = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBindings", oldValue, value);
        }
        return (T)this;
    }

    public T socketBinding(String value) {
        if (this.socketBindings == null) {
            this.socketBindings = new ArrayList<String>();
        }
        this.socketBindings.add(value);
        return (T)this;
    }

    public T socketBindings(String ... args) {
        this.socketBindings(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

