/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.infinispan.remote_cache_container;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=infinispan/remote-cache-container=*/component=transaction")
@ResourceType(value="component")
@Implicit
public class TransactionComponent<T extends TransactionComponent<T>>
implements Keyed {
    private String key = "transaction";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="Sets the cache transaction mode to one of NONE, NON_XA, NON_DURABLE_XA, FULL_XA.")
    private Mode mode;
    @AttributeDocumentation(value="The duration (in ms) after which idle transactions are rolled back.")
    private Long timeout;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="mode")
    public Mode mode() {
        return this.mode;
    }

    public T mode(Mode value) {
        Mode oldValue = this.mode;
        this.mode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mode", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="timeout")
    public Long timeout() {
        return this.timeout;
    }

    public T timeout(Long value) {
        Long oldValue = this.timeout;
        this.timeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("timeout", oldValue, value);
        }
        return (T)this;
    }

    public static enum Mode {
        NONE("NONE"),
        BATCH("BATCH"),
        NON_DURABLE_XA("NON_DURABLE_XA");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Mode(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

