/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.jgroups.stack.relay;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=jgroups/stack=*/relay=relay.RELAY2/remote-site=*")
@ResourceType(value="remote-site")
public class RemoteSite<T extends RemoteSite<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The name of the bridge channel used to communicate with this remote site.")
    private String channel;
    @AttributeDocumentation(value="The cluster name of the bridge channel to this remote site.")
    private String cluster;
    @AttributeDocumentation(value="The stack from which to create a bridge to this remote site.")
    private String stack;

    public RemoteSite(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="channel")
    public String channel() {
        return this.channel;
    }

    public T channel(String value) {
        String oldValue = this.channel;
        this.channel = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("channel", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="cluster")
    public String cluster() {
        return this.cluster;
    }

    @Deprecated
    public T cluster(String value) {
        String oldValue = this.cluster;
        this.cluster = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cluster", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="stack")
    public String stack() {
        return this.stack;
    }

    @Deprecated
    public T stack(String value) {
        String oldValue = this.stack;
        this.stack = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stack", oldValue, value);
        }
        return (T)this;
    }
}

