/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.config.logging.OverflowAction;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=logging/async-handler=*")
@ResourceType(value="async-handler")
public class AsyncHandler<T extends AsyncHandler<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="If set to true the handler is enabled and functioning as normal, if set to false the handler is ignored when processing log messages.")
    private Boolean enabled;
    @AttributeDocumentation(value="Defines a simple filter type.")
    private Map filter;
    @AttributeDocumentation(value="A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match(\"JBAS.*\"))")
    private String filterSpec;
    @AttributeDocumentation(value="The log level specifying which message levels will be logged by this handler. Message levels lower than this value will be discarded.")
    private Level level;
    @AttributeDocumentation(value="The name of the handler.")
    private String name;
    @AttributeDocumentation(value="Specify what action to take when the overflowing.  The valid options are 'block' and 'discard'")
    private OverflowAction overflowAction;
    @AttributeDocumentation(value="The queue length to use before flushing writing")
    private Integer queueLength;
    @AttributeDocumentation(value="The Handlers associated with this async handler.")
    private List<String> subhandlers;

    public AsyncHandler(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="filter")
    public Map filter() {
        return this.filter;
    }

    @Deprecated
    public T filter(Map value) {
        Map oldValue = this.filter;
        this.filter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filter", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T filter(String key, Object value) {
        if (this.filter == null) {
            this.filter = new HashMap();
        }
        this.filter.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filter-spec")
    public String filterSpec() {
        return this.filterSpec;
    }

    public T filterSpec(String value) {
        String oldValue = this.filterSpec;
        this.filterSpec = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filterSpec", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="level")
    public Level level() {
        return this.level;
    }

    public T level(Level value) {
        Level oldValue = this.level;
        this.level = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("level", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="name")
    public String name() {
        return this.name;
    }

    @Deprecated
    public T name(String value) {
        String oldValue = this.name;
        this.name = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("name", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="overflow-action")
    public OverflowAction overflowAction() {
        return this.overflowAction;
    }

    public T overflowAction(OverflowAction value) {
        OverflowAction oldValue = this.overflowAction;
        this.overflowAction = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("overflowAction", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="queue-length")
    public Integer queueLength() {
        return this.queueLength;
    }

    public T queueLength(Integer value) {
        Integer oldValue = this.queueLength;
        this.queueLength = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queueLength", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="subhandlers")
    public List<String> subhandlers() {
        return this.subhandlers;
    }

    public T subhandlers(List<String> value) {
        List<String> oldValue = this.subhandlers;
        this.subhandlers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("subhandlers", oldValue, value);
        }
        return (T)this;
    }

    public T subhandler(String value) {
        if (this.subhandlers == null) {
            this.subhandlers = new ArrayList<String>();
        }
        this.subhandlers.add(value);
        return (T)this;
    }

    public T subhandlers(String ... args) {
        this.subhandlers(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

