/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=logging/custom-handler=*")
@ResourceType(value="custom-handler")
public class CustomHandler<T extends CustomHandler<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The logging handler class to be used.")
    private String attributeClass;
    @AttributeDocumentation(value="If set to true the handler is enabled and functioning as normal, if set to false the handler is ignored when processing log messages.")
    private Boolean enabled;
    @AttributeDocumentation(value="The character encoding used by this Handler.")
    private String encoding;
    @AttributeDocumentation(value="Defines a simple filter type.")
    private Map filter;
    @AttributeDocumentation(value="A filter expression value to define a filter. Example for a filter that does not match a pattern: not(match(\"JBAS.*\"))")
    private String filterSpec;
    @AttributeDocumentation(value="Defines a pattern for the formatter.")
    private String formatter;
    @AttributeDocumentation(value="The log level specifying which message levels will be logged by this logger. Message levels lower than this value will be discarded.")
    private Level level;
    @AttributeDocumentation(value="The module that the logging handler depends on.")
    private String module;
    @AttributeDocumentation(value="The name of the handler.")
    private String name;
    @AttributeDocumentation(value="The name of the defined formatter to be used on the handler.")
    private String namedFormatter;
    @AttributeDocumentation(value="Defines the properties used for the logging handler. All properties must be accessible via a setter method.")
    private Map properties;

    public CustomHandler(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="class")
    public String attributeClass() {
        return this.attributeClass;
    }

    public T attributeClass(String value) {
        String oldValue = this.attributeClass;
        this.attributeClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="encoding")
    public String encoding() {
        return this.encoding;
    }

    public T encoding(String value) {
        String oldValue = this.encoding;
        this.encoding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("encoding", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="filter")
    public Map filter() {
        return this.filter;
    }

    @Deprecated
    public T filter(Map value) {
        Map oldValue = this.filter;
        this.filter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filter", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    public T filter(String key, Object value) {
        if (this.filter == null) {
            this.filter = new HashMap();
        }
        this.filter.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filter-spec")
    public String filterSpec() {
        return this.filterSpec;
    }

    public T filterSpec(String value) {
        String oldValue = this.filterSpec;
        this.filterSpec = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filterSpec", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="formatter")
    public String formatter() {
        return this.formatter;
    }

    public T formatter(String value) {
        String oldValue = this.formatter;
        this.formatter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("formatter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="level")
    public Level level() {
        return this.level;
    }

    public T level(Level value) {
        Level oldValue = this.level;
        this.level = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("level", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @Deprecated
    @ModelNodeBinding(detypedName="name")
    public String name() {
        return this.name;
    }

    @Deprecated
    public T name(String value) {
        String oldValue = this.name;
        this.name = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("name", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="named-formatter")
    public String namedFormatter() {
        return this.namedFormatter;
    }

    public T namedFormatter(String value) {
        String oldValue = this.namedFormatter;
        this.namedFormatter = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("namedFormatter", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }
}

