/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=logging/logging-profile=*/filter=*", "/subsystem=logging/filter=*"})
@ResourceType(value="filter")
public class Filter<T extends Filter<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The logging filter class to be used.")
    private String attributeClass;
    @AttributeDocumentation(value="Defines the constructor properties used for the logging filter.")
    private Map constructorProperties;
    @AttributeDocumentation(value="The module that the logging filter depends on.")
    private String module;
    @AttributeDocumentation(value="Defines the properties used for the logging filter. All properties must be accessible via a setter method.")
    private Map properties;

    public Filter(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="class")
    public String attributeClass() {
        return this.attributeClass;
    }

    public T attributeClass(String value) {
        String oldValue = this.attributeClass;
        this.attributeClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="constructor-properties")
    public Map constructorProperties() {
        return this.constructorProperties;
    }

    public T constructorProperties(Map value) {
        Map oldValue = this.constructorProperties;
        this.constructorProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("constructorProperties", oldValue, value);
        }
        return (T)this;
    }

    public T constructorProperty(String key, Object value) {
        if (this.constructorProperties == null) {
            this.constructorProperties = new HashMap();
        }
        this.constructorProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }
}

