/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.messaging.activemq.FactoryType;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/connection-factory=*")
@ResourceType(value="connection-factory")
public class ConnectionFactory<T extends ConnectionFactory<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.")
    private List<String> connectors;
    @AttributeDocumentation(value="The discovery group name.")
    private String discoveryGroup;
    @AttributeDocumentation(value="Enable the use of ActiveMQ 1.5.x prefixes in the addresses.")
    private Boolean enableAmq1Prefix;
    @AttributeDocumentation(value="The jndi names the connection factory should be bound to.")
    private List<String> entries;
    @AttributeDocumentation(value="The type of connection factory.")
    private FactoryType factoryType;
    @AttributeDocumentation(value="Whether the connection factory supports High Availability.")
    private Boolean ha;
    @AttributeDocumentation(value="Whether to use topology information from the cluster to connect to it. If set to 'false', only the initial connector will be used.")
    private Boolean useTopologyForLoadBalancing;

    public ConnectionFactory(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="connectors")
    public List<String> connectors() {
        return this.connectors;
    }

    public T connectors(List<String> value) {
        List<String> oldValue = this.connectors;
        this.connectors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectors", oldValue, value);
        }
        return (T)this;
    }

    public T connector(String value) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<String>();
        }
        this.connectors.add(value);
        return (T)this;
    }

    public T connectors(String ... args) {
        this.connectors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="discovery-group")
    public String discoveryGroup() {
        return this.discoveryGroup;
    }

    public T discoveryGroup(String value) {
        String oldValue = this.discoveryGroup;
        this.discoveryGroup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("discoveryGroup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enable-amq1-prefix")
    public Boolean enableAmq1Prefix() {
        return this.enableAmq1Prefix;
    }

    public T enableAmq1Prefix(Boolean value) {
        Boolean oldValue = this.enableAmq1Prefix;
        this.enableAmq1Prefix = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableAmq1Prefix", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="entries")
    public List<String> entries() {
        return this.entries;
    }

    public T entries(List<String> value) {
        List<String> oldValue = this.entries;
        this.entries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("entries", oldValue, value);
        }
        return (T)this;
    }

    public T entry(String value) {
        if (this.entries == null) {
            this.entries = new ArrayList<String>();
        }
        this.entries.add(value);
        return (T)this;
    }

    public T entries(String ... args) {
        this.entries(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="factory-type")
    public FactoryType factoryType() {
        return this.factoryType;
    }

    public T factoryType(FactoryType value) {
        FactoryType oldValue = this.factoryType;
        this.factoryType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("factoryType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ha")
    public Boolean ha() {
        return this.ha;
    }

    public T ha(Boolean value) {
        Boolean oldValue = this.ha;
        this.ha = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ha", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-topology-for-load-balancing")
    public Boolean useTopologyForLoadBalancing() {
        return this.useTopologyForLoadBalancing;
    }

    public T useTopologyForLoadBalancing(Boolean value) {
        Boolean oldValue = this.useTopologyForLoadBalancing;
        this.useTopologyForLoadBalancing = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useTopologyForLoadBalancing", oldValue, value);
        }
        return (T)this;
    }
}

