/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/external-jms-queue=*")
@ResourceType(value="external-jms-queue")
public class ExternalJMSQueue<T extends ExternalJMSQueue<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The jndi names the queue will be bound to.")
    private List<String> entries;

    public ExternalJMSQueue(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="entries")
    public List<String> entries() {
        return this.entries;
    }

    public T entries(List<String> value) {
        List<String> oldValue = this.entries;
        this.entries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("entries", oldValue, value);
        }
        return (T)this;
    }

    public T entry(String value) {
        if (this.entries == null) {
            this.entries = new ArrayList<String>();
        }
        this.entries.add(value);
        return (T)this;
    }

    public T entries(String ... args) {
        this.entries(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

