/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=messaging-activemq/http-connector=*", "/subsystem=messaging-activemq/server=*/http-connector=*"})
@ResourceType(value="http-connector")
public class HTTPConnector<T extends HTTPConnector<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The http-acceptor that serves as the endpoint of this http-connector.")
    private String endpoint;
    @AttributeDocumentation(value="A key-value pair understood by the connector factory-class and used to configure it.")
    private Map params;
    @AttributeDocumentation(value="The name of the ActiveMQ Artemis server that will be connected to on the remote server. If undefined, the name of the parent ActiveMQ Artemis server will be used (suitable if the http-connector is used to connect to the parent server)")
    private String serverName;
    @AttributeDocumentation(value="The socket binding that the connector will use to create connections.")
    private String socketBinding;

    public HTTPConnector(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="endpoint")
    public String endpoint() {
        return this.endpoint;
    }

    public T endpoint(String value) {
        String oldValue = this.endpoint;
        this.endpoint = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("endpoint", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="params")
    public Map params() {
        return this.params;
    }

    public T params(Map value) {
        Map oldValue = this.params;
        this.params = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("params", oldValue, value);
        }
        return (T)this;
    }

    public T param(String key, Object value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        this.params.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-name")
    public String serverName() {
        return this.serverName;
    }

    public T serverName(String value) {
        String oldValue = this.serverName;
        this.serverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }
}

