/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.MasterConfiguration;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.MasterConfigurationConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.MasterConfigurationSupplier;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.SlaveConfiguration;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.SlaveConfigurationConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.ha_policy.replication_colocated.SlaveConfigurationSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=messaging-activemq/server=*/ha-policy=replication-colocated")
@ResourceType(value="ha-policy")
@Implicit
public class ReplicationColocatedHAPolicy<T extends ReplicationColocatedHAPolicy<T>>
implements Keyed {
    private String key = "replication-colocated";
    private PropertyChangeSupport pcs;
    private ReplicationColocatedHAPolicyResources subresources = new ReplicationColocatedHAPolicyResources();
    @AttributeDocumentation(value="The offset to use for the Connectors and Acceptors when creating a new backup server.")
    private Integer backupPortOffset;
    @AttributeDocumentation(value="How many times the live server will try to request a backup, -1 means for ever.")
    private Integer backupRequestRetries;
    @AttributeDocumentation(value="How long (in ms) to wait for retries between attempts to request a backup server.")
    private Long backupRequestRetryInterval;
    @AttributeDocumentation(value="The connectors that must not have their port offset.")
    private List<String> excludedConnectors;
    @AttributeDocumentation(value="Whether or not this live server will accept backup requests from other live servers.")
    private Integer maxBackups;
    @AttributeDocumentation(value="If true then the server will request a backup on another node.")
    private Boolean requestBackup;

    public ReplicationColocatedHAPolicy() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ReplicationColocatedHAPolicyResources subresources() {
        return this.subresources;
    }

    public T masterConfiguration(MasterConfiguration value) {
        this.subresources.masterConfiguration = value;
        return (T)this;
    }

    public T masterConfiguration(MasterConfigurationConsumer consumer) {
        MasterConfiguration child = new MasterConfiguration();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.masterConfiguration = child;
        return (T)this;
    }

    public T masterConfiguration() {
        MasterConfiguration child = new MasterConfiguration();
        this.subresources.masterConfiguration = child;
        return (T)this;
    }

    public T masterConfiguration(MasterConfigurationSupplier supplier) {
        this.subresources.masterConfiguration = supplier.get();
        return (T)this;
    }

    public T slaveConfiguration(SlaveConfiguration value) {
        this.subresources.slaveConfiguration = value;
        return (T)this;
    }

    public T slaveConfiguration(SlaveConfigurationConsumer consumer) {
        SlaveConfiguration child = new SlaveConfiguration();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.slaveConfiguration = child;
        return (T)this;
    }

    public T slaveConfiguration() {
        SlaveConfiguration child = new SlaveConfiguration();
        this.subresources.slaveConfiguration = child;
        return (T)this;
    }

    public T slaveConfiguration(SlaveConfigurationSupplier supplier) {
        this.subresources.slaveConfiguration = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="backup-port-offset")
    public Integer backupPortOffset() {
        return this.backupPortOffset;
    }

    public T backupPortOffset(Integer value) {
        Integer oldValue = this.backupPortOffset;
        this.backupPortOffset = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backupPortOffset", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="backup-request-retries")
    public Integer backupRequestRetries() {
        return this.backupRequestRetries;
    }

    public T backupRequestRetries(Integer value) {
        Integer oldValue = this.backupRequestRetries;
        this.backupRequestRetries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backupRequestRetries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="backup-request-retry-interval")
    public Long backupRequestRetryInterval() {
        return this.backupRequestRetryInterval;
    }

    public T backupRequestRetryInterval(Long value) {
        Long oldValue = this.backupRequestRetryInterval;
        this.backupRequestRetryInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backupRequestRetryInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="excluded-connectors")
    public List<String> excludedConnectors() {
        return this.excludedConnectors;
    }

    public T excludedConnectors(List<String> value) {
        List<String> oldValue = this.excludedConnectors;
        this.excludedConnectors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("excludedConnectors", oldValue, value);
        }
        return (T)this;
    }

    public T excludedConnector(String value) {
        if (this.excludedConnectors == null) {
            this.excludedConnectors = new ArrayList<String>();
        }
        this.excludedConnectors.add(value);
        return (T)this;
    }

    public T excludedConnectors(String ... args) {
        this.excludedConnectors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-backups")
    public Integer maxBackups() {
        return this.maxBackups;
    }

    public T maxBackups(Integer value) {
        Integer oldValue = this.maxBackups;
        this.maxBackups = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxBackups", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-backup")
    public Boolean requestBackup() {
        return this.requestBackup;
    }

    public T requestBackup(Boolean value) {
        Boolean oldValue = this.requestBackup;
        this.requestBackup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("requestBackup", oldValue, value);
        }
        return (T)this;
    }

    public static class ReplicationColocatedHAPolicyResources {
        @SingletonResource
        @ResourceDocumentation(value="A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, replication-colocated, shared-store-master, shared-store-slave, or shared-store-colocated).")
        private MasterConfiguration masterConfiguration;
        @SingletonResource
        @ResourceDocumentation(value="A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, replication-colocated, shared-store-master, shared-store-slave, or shared-store-colocated).")
        private SlaveConfiguration slaveConfiguration;

        @Subresource
        public MasterConfiguration masterConfiguration() {
            return this.masterConfiguration;
        }

        @Subresource
        public SlaveConfiguration slaveConfiguration() {
            return this.slaveConfiguration;
        }
    }
}

