/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.modcluster.proxy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.modcluster.proxy.load_provider.CustomLoadMetric;
import org.wildfly.swarm.config.modcluster.proxy.load_provider.CustomLoadMetricConsumer;
import org.wildfly.swarm.config.modcluster.proxy.load_provider.CustomLoadMetricSupplier;
import org.wildfly.swarm.config.modcluster.proxy.load_provider.LoadMetric;
import org.wildfly.swarm.config.modcluster.proxy.load_provider.LoadMetricConsumer;
import org.wildfly.swarm.config.modcluster.proxy.load_provider.LoadMetricSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=modcluster/proxy=*/load-provider=dynamic")
@ResourceType(value="load-provider")
@Implicit
public class DynamicLoadProvider<T extends DynamicLoadProvider<T>>
implements Keyed {
    private String key = "dynamic";
    private PropertyChangeSupport pcs;
    private DynamicLoadProviderResources subresources = new DynamicLoadProviderResources();
    @AttributeDocumentation(value="The factor by which a historic load values should degrade in significance.")
    private Double decay;
    @AttributeDocumentation(value="The number of historic (previous) load values to consider in the load balance factor computation.")
    private Integer history;
    @AttributeDocumentation(value="Initial load within the range [0..100] with which to prepopulate historical values. Used to gradually drive load to the node. Value of 0 prepopulates with full load and value of -1 disables this behavior.")
    private Integer initialLoad;

    public DynamicLoadProvider() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public DynamicLoadProviderResources subresources() {
        return this.subresources;
    }

    public T loadMetrics(List<LoadMetric> value) {
        this.subresources.loadMetrics = value;
        return (T)this;
    }

    public T loadMetric(LoadMetric value) {
        this.subresources.loadMetrics.add(value);
        return (T)this;
    }

    public T loadMetric(String childKey, LoadMetricConsumer consumer) {
        LoadMetric child = new LoadMetric(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.loadMetric(child);
        return (T)this;
    }

    public T loadMetric(String childKey) {
        this.loadMetric(childKey, null);
        return (T)this;
    }

    public T loadMetric(LoadMetricSupplier supplier) {
        this.loadMetric(supplier.get());
        return (T)this;
    }

    public T customLoadMetrics(List<CustomLoadMetric> value) {
        this.subresources.customLoadMetrics = value;
        return (T)this;
    }

    public T customLoadMetric(CustomLoadMetric value) {
        this.subresources.customLoadMetrics.add(value);
        return (T)this;
    }

    public T customLoadMetric(String childKey, CustomLoadMetricConsumer consumer) {
        CustomLoadMetric child = new CustomLoadMetric(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.customLoadMetric(child);
        return (T)this;
    }

    public T customLoadMetric(String childKey) {
        this.customLoadMetric(childKey, null);
        return (T)this;
    }

    public T customLoadMetric(CustomLoadMetricSupplier supplier) {
        this.customLoadMetric(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="decay")
    public Double decay() {
        return this.decay;
    }

    public T decay(Double value) {
        Double oldValue = this.decay;
        this.decay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("decay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="history")
    public Integer history() {
        return this.history;
    }

    public T history(Integer value) {
        Integer oldValue = this.history;
        this.history = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("history", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="initial-load")
    public Integer initialLoad() {
        return this.initialLoad;
    }

    public T initialLoad(Integer value) {
        Integer oldValue = this.initialLoad;
        this.initialLoad = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initialLoad", oldValue, value);
        }
        return (T)this;
    }

    public static class DynamicLoadProviderResources {
        @ResourceDocumentation(value="Built-in load metric contributing a value to the overall load factor of a node. The load factors from each metric are aggregated according to their weights.")
        @SubresourceInfo(value="loadMetric")
        private List<LoadMetric> loadMetrics = new ArrayList<LoadMetric>();
        @ResourceDocumentation(value="Built-in load metric contributing a value to the overall load factor of a node. The load factors from each metric are aggregated according to their weights.")
        @SubresourceInfo(value="customLoadMetric")
        private List<CustomLoadMetric> customLoadMetrics = new ArrayList<CustomLoadMetric>();

        @Subresource
        public List<LoadMetric> loadMetrics() {
            return this.loadMetrics;
        }

        public LoadMetric loadMetric(String key) {
            return this.loadMetrics.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<CustomLoadMetric> customLoadMetrics() {
            return this.customLoadMetrics;
        }

        public CustomLoadMetric customLoadMetric(String key) {
            return this.customLoadMetrics.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

