/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.remoting;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=remoting/configuration=endpoint")
@ResourceType(value="configuration")
@Implicit
public class EndpointConfiguration<T extends EndpointConfiguration<T>>
implements Keyed {
    private String key = "endpoint";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The authentication realm to use if no authentication CallbackHandler is specified.")
    private String authRealm;
    @AttributeDocumentation(value="Specify the number of times a client is allowed to retry authentication before closing the connection.")
    private Integer authenticationRetries;
    @AttributeDocumentation(value="The SASL authorization ID.  Used as authentication user name to use if no authentication CallbackHandler is specified and the selected SASL mechanism demands a user name.")
    private String authorizeId;
    @AttributeDocumentation(value="The size of allocated buffer regions.")
    private Integer bufferRegionSize;
    @AttributeDocumentation(value="The interval to use for connection heartbeat, in milliseconds. If the connection is idle in the outbound direction for this amount of time, a ping message will be sent, which will trigger a corresponding reply message.")
    private Integer heartbeatInterval;
    @AttributeDocumentation(value="The maximum number of inbound channels to support for a connection.")
    private Integer maxInboundChannels;
    @AttributeDocumentation(value="The maximum inbound message size to be allowed.  Messages exceeding this size will cause an exception to be thrown on the reading side as well as the writing side.")
    private Long maxInboundMessageSize;
    @AttributeDocumentation(value="The maximum number of concurrent inbound messages on a channel.")
    private Integer maxInboundMessages;
    @AttributeDocumentation(value="The maximum number of outbound channels to support for a connection.")
    private Integer maxOutboundChannels;
    @AttributeDocumentation(value="The maximum outbound message size to send.  No messages larger than this well be transmitted; attempting to do so will cause an exception on the writing side.")
    private Long maxOutboundMessageSize;
    @AttributeDocumentation(value="The maximum number of concurrent outbound messages on a channel.")
    private Integer maxOutboundMessages;
    @AttributeDocumentation(value="The size of the largest buffer that this endpoint will accept over a connection.")
    private Integer receiveBufferSize;
    @AttributeDocumentation(value="The maximum window size of the receive direction for connection channels, in bytes.")
    private Integer receiveWindowSize;
    @AttributeDocumentation(value="Where a SaslServer or SaslClient are created by default the protocol specified it 'remoting', this can be used to override this.")
    private String saslProtocol;
    @AttributeDocumentation(value="The size of the largest buffer that this endpoint will transmit over a connection.")
    private Integer sendBufferSize;
    @AttributeDocumentation(value="The server side of the connection passes it's name to the client in the initial greeting, by default the name is automatically discovered from the local address of the connection or it can be overridden using this.")
    private String serverName;
    @AttributeDocumentation(value="The maximum window size of the transmit direction for connection channels, in bytes.")
    private Integer transmitWindowSize;
    @AttributeDocumentation(value="Worker to use")
    private String worker;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="auth-realm")
    public String authRealm() {
        return this.authRealm;
    }

    public T authRealm(String value) {
        String oldValue = this.authRealm;
        this.authRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-retries")
    public Integer authenticationRetries() {
        return this.authenticationRetries;
    }

    public T authenticationRetries(Integer value) {
        Integer oldValue = this.authenticationRetries;
        this.authenticationRetries = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationRetries", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authorize-id")
    public String authorizeId() {
        return this.authorizeId;
    }

    public T authorizeId(String value) {
        String oldValue = this.authorizeId;
        this.authorizeId = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authorizeId", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffer-region-size")
    public Integer bufferRegionSize() {
        return this.bufferRegionSize;
    }

    public T bufferRegionSize(Integer value) {
        Integer oldValue = this.bufferRegionSize;
        this.bufferRegionSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferRegionSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="heartbeat-interval")
    public Integer heartbeatInterval() {
        return this.heartbeatInterval;
    }

    public T heartbeatInterval(Integer value) {
        Integer oldValue = this.heartbeatInterval;
        this.heartbeatInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("heartbeatInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-inbound-channels")
    public Integer maxInboundChannels() {
        return this.maxInboundChannels;
    }

    public T maxInboundChannels(Integer value) {
        Integer oldValue = this.maxInboundChannels;
        this.maxInboundChannels = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxInboundChannels", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-inbound-message-size")
    public Long maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public T maxInboundMessageSize(Long value) {
        Long oldValue = this.maxInboundMessageSize;
        this.maxInboundMessageSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxInboundMessageSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-inbound-messages")
    public Integer maxInboundMessages() {
        return this.maxInboundMessages;
    }

    public T maxInboundMessages(Integer value) {
        Integer oldValue = this.maxInboundMessages;
        this.maxInboundMessages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxInboundMessages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-outbound-channels")
    public Integer maxOutboundChannels() {
        return this.maxOutboundChannels;
    }

    public T maxOutboundChannels(Integer value) {
        Integer oldValue = this.maxOutboundChannels;
        this.maxOutboundChannels = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxOutboundChannels", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-outbound-message-size")
    public Long maxOutboundMessageSize() {
        return this.maxOutboundMessageSize;
    }

    public T maxOutboundMessageSize(Long value) {
        Long oldValue = this.maxOutboundMessageSize;
        this.maxOutboundMessageSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxOutboundMessageSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-outbound-messages")
    public Integer maxOutboundMessages() {
        return this.maxOutboundMessages;
    }

    public T maxOutboundMessages(Integer value) {
        Integer oldValue = this.maxOutboundMessages;
        this.maxOutboundMessages = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxOutboundMessages", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="receive-buffer-size")
    public Integer receiveBufferSize() {
        return this.receiveBufferSize;
    }

    public T receiveBufferSize(Integer value) {
        Integer oldValue = this.receiveBufferSize;
        this.receiveBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("receiveBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="receive-window-size")
    public Integer receiveWindowSize() {
        return this.receiveWindowSize;
    }

    public T receiveWindowSize(Integer value) {
        Integer oldValue = this.receiveWindowSize;
        this.receiveWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("receiveWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-protocol")
    public String saslProtocol() {
        return this.saslProtocol;
    }

    public T saslProtocol(String value) {
        String oldValue = this.saslProtocol;
        this.saslProtocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("saslProtocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="send-buffer-size")
    public Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    public T sendBufferSize(Integer value) {
        Integer oldValue = this.sendBufferSize;
        this.sendBufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sendBufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-name")
    public String serverName() {
        return this.serverName;
    }

    public T serverName(String value) {
        String oldValue = this.serverName;
        this.serverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="transmit-window-size")
    public Integer transmitWindowSize() {
        return this.transmitWindowSize;
    }

    public T transmitWindowSize(Integer value) {
        Integer oldValue = this.transmitWindowSize;
        this.transmitWindowSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("transmitWindowSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker")
    public String worker() {
        return this.worker;
    }

    public T worker(String value) {
        String oldValue = this.worker;
        this.worker = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("worker", oldValue, value);
        }
        return (T)this;
    }
}

