/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModule;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleSupplier;

@Address(value="/subsystem=security/security-domain=*/authentication=classic")
@ResourceType(value="authentication")
@Implicit
public class ClassicAuthentication<T extends ClassicAuthentication<T>>
implements Keyed {
    private String key = "classic";
    private PropertyChangeSupport pcs;
    private ClassicAuthenticationResources subresources = new ClassicAuthenticationResources();

    public ClassicAuthentication() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ClassicAuthenticationResources subresources() {
        return this.subresources;
    }

    public T loginModules(List<LoginModule> value) {
        this.subresources.loginModules = value;
        return (T)this;
    }

    public T loginModule(LoginModule value) {
        this.subresources.loginModules.add(value);
        return (T)this;
    }

    public T loginModule(String childKey, LoginModuleConsumer consumer) {
        LoginModule child = new LoginModule(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.loginModule(child);
        return (T)this;
    }

    public T loginModule(String childKey) {
        this.loginModule(childKey, null);
        return (T)this;
    }

    public T loginModule(LoginModuleSupplier supplier) {
        this.loginModule(supplier.get());
        return (T)this;
    }

    public static class ClassicAuthenticationResources {
        @ResourceDocumentation(value="List of authentication modules")
        @SubresourceInfo(value="loginModule")
        private List<LoginModule> loginModules = new ArrayList<LoginModule>();

        @Subresource
        public List<LoginModule> loginModules() {
            return this.loginModules;
        }

        public LoginModule loginModule(String key) {
            return this.loginModules.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

