/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.singleton.singleton_policy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=singleton/singleton-policy=*/service=*")
@ResourceType(value="service")
public class Service<T extends Service<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Indicates whether the local member is the primary provider of this singleton service")
    private Boolean isPrimary;
    @AttributeDocumentation(value="The primary provider of this singleton service")
    private String primaryProvider;
    @AttributeDocumentation(value="The members on which the singleton service is installed")
    private List<String> providers;

    public Service(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="is-primary")
    public Boolean isPrimary() {
        return this.isPrimary;
    }

    public T isPrimary(Boolean value) {
        Boolean oldValue = this.isPrimary;
        this.isPrimary = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("isPrimary", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="primary-provider")
    public String primaryProvider() {
        return this.primaryProvider;
    }

    public T primaryProvider(String value) {
        String oldValue = this.primaryProvider;
        this.primaryProvider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("primaryProvider", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="providers")
    public List<String> providers() {
        return this.providers;
    }

    public T providers(List<String> value) {
        List<String> oldValue = this.providers;
        this.providers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("providers", oldValue, value);
        }
        return (T)this;
    }

    public T provider(String value) {
        if (this.providers == null) {
            this.providers = new ArrayList<String>();
        }
        this.providers.add(value);
        return (T)this;
    }

    public T providers(String ... args) {
        this.providers(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

